/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRuleList;

public abstract class BaseDocumentCSSStyleSheet
extends BaseCSSStyleSheet
implements DocumentCSSStyleSheet,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String targetMedium = null;
    private Map<String, CSSPropertyDefinition> registeredPropertyMap;

    protected BaseDocumentCSSStyleSheet(String medium, byte origin) {
        super(null, new MediaQueryListImpl(medium), null, origin);
        this.targetMedium = "all".equals(medium) ? null : medium;
        this.registeredPropertyMap = new HashMap<String, CSSPropertyDefinition>();
    }

    @Override
    public void setHref(String href) {
        if (this.getOrigin() != 9 && this.getOrigin() != 3) {
            throw new IllegalStateException("Document sheet's href is parent document href");
        }
        super.setHref(href);
    }

    @Override
    public String getHref() {
        return this.getOwnerNode() != null ? this.getOwnerNode().getBaseURI() : super.getHref();
    }

    @Override
    public abstract CSSDocument getOwnerNode();

    public abstract void setOwnerDocument(CSSDocument var1);

    protected void copyToTarget(BaseDocumentCSSStyleSheet myCopy) {
        if (myCopy.getTargetMedium() == null) {
            throw new NullPointerException();
        }
        CSSDocument doc = myCopy.getOwnerNode();
        CSSCanvas canvas = doc != null ? doc.getCanvas() : null;
        if (!this.getMedia().matches(myCopy.getTargetMedium(), canvas)) {
            throw new IllegalArgumentException("Incompatible target medium: " + this.targetMedium);
        }
        this.copyFieldsTo(myCopy);
        myCopy.cssRules.ensureCapacity(this.cssRules.getLength());
        for (AbstractCSSRule rule : this.cssRules) {
            short type = rule.getType();
            if (type == 4 && !((MediaRule)rule).getMedia().matches(this.targetMedium, canvas) || type == 3 && !((ImportRule)rule).getMedia().matches(this.targetMedium, canvas)) continue;
            if (type == 18) {
                this.registerProperty((CSSPropertyDefinition)((Object)rule));
                continue;
            }
            myCopy.cssRules.add(rule.clone(myCopy));
        }
    }

    @Override
    protected void addLocalRule(CSSRule rule) {
        if (rule.getType() == 18) {
            this.registerProperty((CSSPropertyDefinition)((Object)rule));
        } else {
            super.addLocalRule(rule);
        }
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public abstract ComputedCSSStyle getComputedStyle(CSSElement var1, Condition var2);

    protected abstract ComputedCSSStyle createComputedCSSStyle();

    @Override
    public abstract BaseDocumentCSSStyleSheet clone();

    @Override
    public abstract BaseDocumentCSSStyleSheet clone(String var1);

    CSSPropertyDefinition getPropertyDefinition(String name) {
        return this.registeredPropertyMap.get(name);
    }

    @Override
    public void registerProperty(CSSPropertyDefinition definition) {
        this.registeredPropertyMap.put(definition.getName(), definition);
    }

    protected ComputedCSSStyle computeStyle(ComputedCSSStyle style, SelectorMatcher matcher, Condition pseudoElt, InlineStyle inlineStyle) {
        AbstractCSSStyleSheet userImportantStyleSheet;
        if (this.getDisabled()) {
            return style;
        }
        matcher.setPseudoElement(pseudoElt);
        CSSElement elt = style.getOwnerNode();
        ErrorHandler errHandler = elt.getOwnerDocument().getErrorHandler();
        errHandler.resetComputedStyleErrors(elt);
        if (elt.hasPresentationalHints()) {
            try {
                elt.exportHintsToStyle(style);
            }
            catch (DOMException e) {
                errHandler.presentationalHintError(elt, e);
            }
        }
        Cascade matchingStyles = new Cascade();
        matchingStyles.cascade(matcher, this.getTargetMedium(), this.cssRules);
        Iterator<StyleRule> styleit = matchingStyles.iterator();
        while (styleit.hasNext()) {
            StyleRule rule = styleit.next();
            style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
        }
        if (inlineStyle != null && !inlineStyle.isEmpty()) {
            style.addStyle(inlineStyle);
        }
        if (elt.hasOverrideStyle(pseudoElt)) {
            BaseCSSStyleDeclaration ovstyle = (BaseCSSStyleDeclaration)elt.getOverrideStyle(pseudoElt);
            style.addStyle(ovstyle);
        }
        if ((userImportantStyleSheet = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade usercascade = new Cascade();
            usercascade.cascade(matcher, this.getTargetMedium(), userImportantStyleSheet.getCssRules());
            styleit = usercascade.iterator();
            while (styleit.hasNext()) {
                StyleRule rule = styleit.next();
                style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
            }
        }
        return style;
    }

    protected ComputedCSSStyle computeRevertedStyle(ComputedCSSStyle style, SelectorMatcher matcher, Condition pseudoElt, BaseCSSStyleDeclaration inlineStyle, byte origin) {
        AbstractCSSStyleSheet userImportantStyleSheet;
        matcher.setPseudoElement(pseudoElt);
        CSSElement elt = style.getOwnerNode();
        ErrorHandler errHandler = elt.getOwnerDocument().getErrorHandler();
        errHandler.resetComputedStyleErrors(elt);
        if (origin >= 8 && elt.hasPresentationalHints()) {
            try {
                elt.exportHintsToStyle(style);
            }
            catch (DOMException e) {
                errHandler.presentationalHintError(elt, e);
            }
        }
        Cascade matchingStyles = new Cascade();
        matchingStyles.cascade(matcher, this.getTargetMedium(), this.cssRules, origin);
        Iterator<StyleRule> styleit = matchingStyles.iterator();
        while (styleit.hasNext()) {
            StyleRule rule = styleit.next();
            style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
        }
        if (origin >= 8) {
            if (inlineStyle != null && !inlineStyle.isEmpty()) {
                style.addStyle(inlineStyle);
            }
            if (elt.hasOverrideStyle(pseudoElt)) {
                style.addStyle((BaseCSSStyleDeclaration)elt.getOverrideStyle(pseudoElt));
            }
        }
        if (origin >= 3 && (userImportantStyleSheet = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade usercascade = new Cascade();
            usercascade.cascade(matcher, this.getTargetMedium(), userImportantStyleSheet.getCssRules());
            styleit = usercascade.iterator();
            while (styleit.hasNext()) {
                StyleRule rule = styleit.next();
                style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
            }
        }
        return style;
    }

    CSSCanvas getCanvas() {
        CSSCanvas canvas = this.getOwnerNode() != null ? this.getOwnerNode().getCanvas() : null;
        return canvas;
    }

    class Cascade {
        private final SortedMap<StyleRule.RuleSpecificity, LinkedList<StyleRule>> matchingStyles = new TreeMap<StyleRule.RuleSpecificity, LinkedList<StyleRule>>(new StyleRule.SpecificityComparator());

        Cascade() {
        }

        void cascade(SelectorMatcher matcher, String targetMedium, CSSRuleArrayList list) {
            for (CSSRule rule : list) {
                short type = rule.getType();
                if (type != 1) {
                    StyleDatabase sdb;
                    if (type == 4) {
                        this.scanMediaRule(matcher, targetMedium, BaseDocumentCSSStyleSheet.this.getCanvas(), (MediaRule)rule);
                        continue;
                    }
                    if (type == 5) {
                        this.processFontFaceRule((FontFaceRule)rule, targetMedium);
                        continue;
                    }
                    if (type != 12) continue;
                    SupportsRule supports = (SupportsRule)rule;
                    DeviceFactory df = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
                    if (df == null || (sdb = df.getStyleDatabase(targetMedium)) == null || !supports.supports(sdb)) continue;
                    CSSRuleArrayList rules = supports.getCssRules();
                    this.cascade(matcher, targetMedium, rules);
                    continue;
                }
                StyleRule stylerule = (StyleRule)rule;
                int selIdx = matcher.matches(stylerule.getSelectorList());
                if (selIdx == -1) continue;
                this.add(stylerule.getSpecificity(selIdx, matcher));
            }
        }

        private void scanMediaRule(SelectorMatcher matcher, String targetMedium, CSSCanvas canvas, MediaRule mediaRule) {
            MediaQueryList mediaList = mediaRule.getMedia();
            if (targetMedium != null ? mediaList.matches(targetMedium, canvas) : mediaList.isAllMedia()) {
                CSSRuleList ruleList = mediaRule.getCssRules();
                this.cascade(matcher, targetMedium, (CSSRuleArrayList)ruleList);
            }
        }

        private void processFontFaceRule(FontFaceRule rule, String targetMedium) {
            StyleDatabase sdb;
            DeviceFactory df = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
            if (df != null && (sdb = df.getStyleDatabase(targetMedium)) != null) {
                sdb.loadFontFaceRule(rule);
            }
        }

        void add(StyleRule.RuleSpecificity sp) {
            if (this.matchingStyles.containsKey(sp)) {
                ((LinkedList)this.matchingStyles.get(sp)).add(sp.getCSSStyleRule());
            } else {
                LinkedList<StyleRule> matchingRules = new LinkedList<StyleRule>();
                matchingRules.add(sp.getCSSStyleRule());
                this.matchingStyles.put(sp, matchingRules);
            }
        }

        public void cascade(SelectorMatcher matcher, String targetMedium, CSSRuleArrayList list, byte origin) {
            for (AbstractCSSRule rule : list) {
                if (rule.getOrigin() < origin) continue;
                short type = rule.getType();
                if (type != 1 && type != 6) {
                    StyleDatabase sdb;
                    if (type == 4) {
                        this.scanMediaRule(matcher, targetMedium, BaseDocumentCSSStyleSheet.this.getCanvas(), (MediaRule)rule);
                        continue;
                    }
                    if (type == 5) {
                        this.processFontFaceRule((FontFaceRule)rule, targetMedium);
                        continue;
                    }
                    if (type != 12) continue;
                    SupportsRule supports = (SupportsRule)rule;
                    DeviceFactory df = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
                    if (df == null || (sdb = df.getStyleDatabase(targetMedium)) == null || !supports.supports(sdb)) continue;
                    CSSRuleArrayList rules = supports.getCssRules();
                    this.cascade(matcher, targetMedium, rules);
                    continue;
                }
                StyleRule stylerule = (StyleRule)rule;
                int selIdx = matcher.matches(stylerule.getSelectorList());
                if (selIdx == -1) continue;
                this.add(stylerule.getSpecificity(selIdx, matcher));
            }
        }

        Iterator<StyleRule> iterator() {
            return new RuleIterator();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            Iterator<StyleRule> it = this.iterator();
            while (it.hasNext()) {
                StyleRule rule = it.next();
                buf.append(rule.getOrigin()).append(": ").append(rule.getCssText()).append('\n');
            }
            return buf.toString();
        }

        class RuleIterator
        implements Iterator<StyleRule> {
            private final Iterator<StyleRule.RuleSpecificity> keyit;
            private Iterator<StyleRule> currentList;

            RuleIterator() {
                this.keyit = Cascade.this.matchingStyles.keySet().iterator();
                if (this.keyit.hasNext()) {
                    this.findCurrentList();
                } else {
                    this.currentList = null;
                }
            }

            private void findCurrentList() {
                while (this.currentList == null || !this.currentList.hasNext()) {
                    if (this.keyit.hasNext()) {
                        this.currentList = ((LinkedList)Cascade.this.matchingStyles.get(this.keyit.next())).iterator();
                        continue;
                    }
                    this.currentList = null;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentList != null;
            }

            @Override
            public StyleRule next() {
                if (this.currentList != null && this.currentList.hasNext()) {
                    StyleRule thenext = this.currentList.next();
                    this.findCurrentList();
                    return thenext;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

