/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class BorderShorthandSetter
extends ShorthandSetter {
    BorderShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "border");
    }

    @Override
    public boolean assignSubproperties() {
        if (super.assignSubproperties()) {
            this.styleDeclaration.getShorthandSet().remove("border-image");
            return true;
        }
        return false;
    }

    @Override
    protected boolean assignSubproperty(String subproperty) {
        if ("border-width".equals(subproperty)) {
            if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty) || ValueFactory.isSizeSACUnit(this.currentValue)) {
                StyleValue cssValue = this.createCSSValue("border-width", this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
        } else if ("border-style".equals(subproperty)) {
            LexicalUnit.LexicalType utype = this.currentValue.getLexicalUnitType();
            if (LexicalUnit.LexicalType.IDENT == utype && this.testIdentifiers(subproperty)) {
                StyleValue cssValue = this.createCSSValue("border-style", this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
        } else if ("border-color".equals(subproperty) && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
            StyleValue cssValue = this.createCSSValue("border-color", this.currentValue);
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    @Override
    protected void setSubpropertyValue(String subproperty, StyleValue cssValue) {
        String[] subparray = this.getShorthandDatabase().getShorthandSubproperties(subproperty);
        for (int i = 0; i < subparray.length; ++i) {
            if (i != 0) {
                cssValue = cssValue.clone();
            }
            super.setSubpropertyValue(subparray[i], cssValue);
        }
    }

    @Override
    protected void resetSubproperties() {
        super.resetSubproperties();
        this.setPropertyToDefault("border-image-source");
        this.setPropertyToDefault("border-image-slice");
        this.setPropertyToDefault("border-image-width");
        this.setPropertyToDefault("border-image-outset");
        this.setPropertyToDefault("border-image-repeat");
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue keyword) {
        super.setSubpropertiesToKeyword(keyword);
        this.setProperty("border-image-source", keyword, this.isPriorityImportant());
        this.setProperty("border-image-slice", keyword, this.isPriorityImportant());
        this.setProperty("border-image-width", keyword, this.isPriorityImportant());
        this.setProperty("border-image-outset", keyword, this.isPriorityImportant());
        this.setProperty("border-image-repeat", keyword, this.isPriorityImportant());
        this.flush();
    }
}

