/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class ColumnsShorthandSetter
extends ShorthandSetter {
    ColumnsShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "columns");
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        this.setPropertyToDefault("column-width");
        this.setPropertyToDefault("column-count");
        boolean columnWidthUnset = true;
        boolean columnCountUnset = true;
        int count = 0;
        while (this.currentValue != null) {
            if (count == 2) {
                return false;
            }
            LexicalUnit.LexicalType lut = this.currentValue.getLexicalUnitType();
            if (columnCountUnset && lut == LexicalUnit.LexicalType.INTEGER) {
                int intValue = this.currentValue.getIntegerValue();
                if (intValue < 1) {
                    return false;
                }
                NumberValue number = new NumberValue();
                number.setIntegerValue(intValue);
                number.setSubproperty(true);
                this.setSubpropertyValue("column-count", number);
                count = (byte)(count + 1);
                columnCountUnset = false;
            } else if (columnWidthUnset && ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
                this.setSubpropertyValue("column-width", this.createCSSValue("column-width", this.currentValue));
                count = (byte)(count + 1);
                columnWidthUnset = false;
            } else if (lut == LexicalUnit.LexicalType.IDENT) {
                String ident = this.currentValue.getStringValue();
                if (!"auto".equalsIgnoreCase(ident)) {
                    return false;
                }
                count = (byte)(count + 1);
            } else {
                return false;
            }
            this.nextCurrentValue();
        }
        this.flush();
        return true;
    }
}

