/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CompatDeclarationSet;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

class CompatStyleDeclaration
extends BaseCSSStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private final CompatDeclarationSet compatSet;

    protected CompatStyleDeclaration(BaseCSSDeclarationRule parentRule) {
        super(parentRule);
        this.compatSet = new CompatDeclarationSet();
    }

    protected CompatStyleDeclaration(CompatStyleDeclaration copiedObject) {
        super(copiedObject);
        this.compatSet = copiedObject.compatSet.clone();
    }

    @Override
    protected void setLonghandProperty(String propertyName, LexicalUnit value, boolean important) throws DOMException {
        if (value.getLexicalUnitType() != LexicalUnit.LexicalType.COMPAT_PRIO) {
            super.setLonghandProperty(propertyName, value, important);
        } else {
            StyleValue cssvalue;
            ValueFactory factory = this.getValueFactory();
            try {
                cssvalue = factory.createCSSValue(value, this);
            }
            catch (DOMException e) {
                StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName, e);
                    ex.setValueText(CompatStyleDeclaration.lexicalUnitToString(value));
                    errHandler.wrongValue(propertyName, ex);
                }
                throw e;
            }
            this.compatLonghand(propertyName, cssvalue, true, this.isPropertySet(propertyName));
        }
    }

    @Override
    protected boolean addOverrideProperty(String propertyName, StyleValue cssValue, String priority) {
        return this.addCompatProperty(propertyName, cssValue, priority);
    }

    @Override
    protected void compatLonghand(String propertyName, StyleValue value, boolean priorityImportant, boolean isOverride) {
        this.compatSet.setCompatLonghand(propertyName, value, priorityImportant, isOverride);
    }

    @Override
    protected void shorthandError(String propertyName, LexicalUnit value, boolean important, LinkedList<String> shadowedShorthands, DOMException e) {
        if (this.compatSet.setCompatShorthand(propertyName, value, important, shadowedShorthands)) {
            this.compatWarning(propertyName, value, important);
            return;
        }
        super.shorthandError(propertyName, value, important, shadowedShorthands, e);
    }

    @Override
    protected void appendShorthandMinifiedCssText(StringBuilder sb, String shorthandName, ShorthandValue shval) {
        ShorthandValue compatvalue;
        boolean isCompatOv = this.compatSet.isCompatShorthand(shorthandName);
        if (!isCompatOv && !shval.isImportant() && (compatvalue = this.compatSet.getNonOvCompatShorthand(shorthandName)) != null) {
            CompatDeclarationSet.appendIEPrioCharShorthandMinifiedCssText(sb, shorthandName, compatvalue);
        }
        super.appendShorthandMinifiedCssText(sb, shorthandName, shval);
        if (isCompatOv) {
            compatvalue = this.compatSet.getCompatShorthand(shorthandName);
            if (!compatvalue.isPriorityCompat()) {
                super.appendShorthandMinifiedCssText(sb, shorthandName, compatvalue);
            } else {
                CompatDeclarationSet.appendIEPrioCharShorthandMinifiedCssText(sb, shorthandName, compatvalue);
            }
        }
    }

    @Override
    protected void appendLonghandMinifiedCssText(StringBuilder sb, String ptyname, StyleValue cssVal, boolean important) {
        StyleValue compatvalue;
        boolean isCompatOv = this.compatSet.isCompatLonghand(ptyname);
        if (!isCompatOv && !important && (compatvalue = this.compatSet.getNonOvCompatLonghand(ptyname)) != null) {
            super.appendLonghandMinifiedCssText(sb, ptyname, compatvalue, true);
            sb.append('!').append(';');
        }
        super.appendLonghandMinifiedCssText(sb, ptyname, cssVal, important);
        if (isCompatOv) {
            sb.append(';');
            compatvalue = this.compatSet.getCompatLonghand(ptyname);
            super.appendLonghandMinifiedCssText(sb, ptyname, compatvalue, this.compatSet.isImportantCompatLonghand(ptyname));
            if (CompatDeclarationSet.isPriorityCompat(compatvalue)) {
                sb.append('!');
            }
        }
    }

    @Override
    protected void writeShorthandCssText(SimpleWriter wri, StyleFormattingContext context, String shorthandName, ShorthandValue shval) throws IOException {
        ShorthandValue compatvalue;
        boolean isCompatOv = this.compatSet.isCompatShorthand(shorthandName);
        if (!isCompatOv && !shval.isImportant() && (compatvalue = this.compatSet.getNonOvCompatShorthand(shorthandName)) != null) {
            context.startPropertyDeclaration(wri);
            CompatDeclarationSet.writeIEPrioCharShorthandCssText(wri, context, shorthandName, compatvalue);
            context.endPropertyDeclaration(wri);
        }
        super.writeShorthandCssText(wri, context, shorthandName, shval);
        if (isCompatOv) {
            compatvalue = this.compatSet.getCompatShorthand(shorthandName);
            if (!compatvalue.isPriorityCompat()) {
                super.writeShorthandCssText(wri, context, shorthandName, compatvalue);
            } else {
                context.startPropertyDeclaration(wri);
                CompatDeclarationSet.writeIEPrioCharShorthandCssText(wri, context, shorthandName, compatvalue);
                context.endPropertyDeclaration(wri);
            }
        }
    }

    @Override
    protected void writeLonghandCssText(SimpleWriter wri, StyleFormattingContext context, String ptyname, StyleValue ptyvalue, boolean important) throws IOException {
        StyleValue compatvalue;
        boolean isCompatOv = this.compatSet.isCompatLonghand(ptyname);
        if (!isCompatOv && !important && (compatvalue = this.compatSet.getNonOvCompatLonghand(ptyname)) != null) {
            context.startPropertyDeclaration(wri);
            CompatDeclarationSet.writeIEPrioCharLonghandCssText(wri, context, ptyname, compatvalue);
            context.endPropertyDeclaration(wri);
        }
        super.writeLonghandCssText(wri, context, ptyname, ptyvalue, important);
        if (isCompatOv) {
            compatvalue = this.compatSet.getCompatLonghand(ptyname);
            if (!CompatDeclarationSet.isPriorityCompat(compatvalue)) {
                super.writeLonghandCssText(wri, context, ptyname, compatvalue, this.compatSet.isImportantCompatLonghand(ptyname));
            } else {
                context.startPropertyDeclaration(wri);
                CompatDeclarationSet.writeIEPrioCharLonghandCssText(wri, context, ptyname, compatvalue);
                context.endPropertyDeclaration(wri);
            }
        }
    }

    @Override
    void clear() {
        super.clear();
        this.compatSet.clear();
    }

    @Override
    public CompatStyleDeclaration clone() {
        return new CompatStyleDeclaration(this);
    }
}

