/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSUnknownRule;

public class UnknownRule
extends BaseCSSRule
implements CSSUnknownRule {
    private static final long serialVersionUID = 1L;
    private String cssText = "";

    UnknownRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)0, origin);
    }

    UnknownRule(UnknownRule copyMe) {
        super(copyMe);
        this.cssText = copyMe.cssText;
    }

    @Override
    void clear() {
    }

    @Override
    void setRule(AbstractCSSRule copyMe) {
        UnknownRule other = (UnknownRule)copyMe;
        this.setPrecedingComments(copyMe.getPrecedingComments());
        this.setTrailingComments(copyMe.getTrailingComments());
        this.cssText = other.cssText;
    }

    @Override
    public String getCssText() {
        if (this.cssText.length() == 0) {
            return "";
        }
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(this.cssText.length());
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return CommentRemover.removeComments(this.cssText).toString().trim();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.cssText.length() != 0) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)this.cssText);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    public void setRuleCssText(String cssText) {
        if (cssText == null) {
            throw new NullPointerException("Null rule text.");
        }
        this.cssText = cssText;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cssText.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownRule other = (UnknownRule)obj;
        return this.cssText.equals(other.cssText);
    }

    @Override
    public UnknownRule clone(AbstractCSSStyleSheet parentSheet) {
        return new UnknownRule(this);
    }
}

