/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.util.Visitor;
import org.w3c.dom.DOMException;

public abstract class AttributeConditionVisitor
implements Visitor<AttributeCondition> {
    protected AttributeConditionVisitor() {
    }

    public void visit(SelectorList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Selector selector = list.item(i);
            this.visit(selector);
        }
    }

    public void visit(Selector selector) {
        if (selector.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
            Condition cond = ((ConditionalSelector)selector).getCondition();
            this.visit(cond);
        } else if (selector instanceof CombinatorSelector) {
            Selector sel = ((CombinatorSelector)selector).getSelector();
            this.visit(sel);
        }
    }

    private void visit(Condition condition) {
        if (condition instanceof AttributeCondition) {
            this.visit((AttributeCondition)condition);
        } else {
            switch (condition.getConditionType()) {
                case AND: {
                    CombinatorCondition comb = (CombinatorCondition)condition;
                    this.visit(comb.getFirstCondition());
                    this.visit(comb.getSecondCondition());
                    break;
                }
                case POSITIONAL: {
                    SelectorList selist = ((PositionalCondition)condition).getOfList();
                    if (selist == null) break;
                    this.visit(selist);
                    break;
                }
                case SELECTOR_ARGUMENT: {
                    SelectorList selist = ((ArgumentCondition)condition).getSelectors();
                    if (selist == null) break;
                    this.visit(selist);
                    break;
                }
            }
        }
    }

    protected void setConditionNamespaceURI(AttributeCondition cond, String namespaceURI) throws DOMException {
        if (namespaceURI == null) {
            throw new DOMException(15, "Null namespaceURI.");
        }
        if ((namespaceURI = namespaceURI.trim()).length() == 0) {
            throw new DOMException(15, "Empty namespaceURI.");
        }
        ((NSACSelectorFactory.AttributeConditionImpl)cond).setNamespaceURI(namespaceURI);
    }

    protected void setConditionLocalName(AttributeCondition cond, String newLocalName) throws DOMException {
        if (newLocalName == null) {
            throw new DOMException(15, "Null local name.");
        }
        if ((newLocalName = newLocalName.trim()).length() == 0) {
            throw new DOMException(15, "Empty local name.");
        }
        ((NSACSelectorFactory.AttributeConditionImpl)cond).setLocalName(newLocalName);
    }

    protected void setConditionValue(AttributeCondition cond, String newValue) throws DOMException {
        if (newValue != null) {
            if ((newValue = newValue.trim()).length() == 0) {
                newValue = null;
                if (cond.getConditionType() == Condition.ConditionType.CLASS) {
                    throw new DOMException(15, "Empty value.");
                }
            }
        } else if (cond.getConditionType() == Condition.ConditionType.CLASS) {
            throw new DOMException(15, "Null value.");
        }
        ((NSACSelectorFactory.AttributeConditionImpl)cond).setValue(newValue);
    }

    public abstract void visit(AttributeCondition var1);
}

