/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.LangCondition;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.jclf.text.TokenParser;
import java.io.Serializable;

class LangConditionImpl
implements LangCondition,
Serializable {
    private static final long serialVersionUID = 1L;
    String lang = null;

    LangConditionImpl() {
    }

    @Override
    public Condition.ConditionType getConditionType() {
        return Condition.ConditionType.LANG;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LangConditionImpl other = (LangConditionImpl)obj;
        return !(this.lang == null ? other.lang != null : !this.lang.equals(other.lang));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(":lang(");
        String lang = this.getLang();
        TokenParser parser = new TokenParser(lang, ", ", "\"'");
        String s = parser.next();
        int commaIdx = lang.indexOf(44) + 1;
        buf.append(this.escapeLang(s, lang, commaIdx));
        while (parser.hasNext()) {
            s = parser.next();
            commaIdx = lang.indexOf(44, commaIdx) + 1;
            buf.append(',').append(this.escapeLang(s, lang, commaIdx));
        }
        buf.append(')');
        return buf.toString();
    }

    private String escapeLang(String s, String lang, int commaIdx) {
        boolean noDQ;
        int nextCommaIdx = lang.indexOf(44, commaIdx) + 1;
        int nextDQIdx = lang.indexOf(34, commaIdx);
        int nextSQIdx = lang.indexOf(39, commaIdx);
        boolean bl = noDQ = nextDQIdx == -1 || nextDQIdx > nextCommaIdx;
        if (s.indexOf(32) != -1) {
            char quote = noDQ ? (char)'\'' : '\"';
            s = ParseHelper.quote(s, quote);
        } else {
            CharSequence escaped = ParseHelper.escapeCssCharsAndFirstChar(s);
            if (escaped != s) {
                boolean noSQ;
                boolean bl2 = noSQ = nextSQIdx == -1 || nextSQIdx > nextCommaIdx;
                if (escaped.length() < s.length() + 2 && noDQ && noSQ) {
                    s = escaped.toString();
                } else {
                    char quote = noDQ ? (char)'\'' : '\"';
                    s = ParseHelper.quote(s, quote);
                }
            }
        }
        return s;
    }
}

