/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import java.io.Serializable;
import java.util.Locale;
import org.w3c.dom.DOMException;

class LexicalUnitImpl
implements LexicalUnit,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LEXICAL_REPLACE_LIMIT = 262144;
    private LexicalUnit.LexicalType unitType;
    private short cssUnit = (short)255;
    int intValue = 0;
    float floatValue = Float.NaN;
    String dimensionUnitText = "";
    String value = null;
    String identCssText = null;
    LexicalUnitImpl previousLexicalUnit = null;
    LexicalUnitImpl nextLexicalUnit = null;
    LexicalUnitImpl parameters = null;
    LexicalUnitImpl ownerLexicalUnit = null;

    public LexicalUnitImpl(LexicalUnit.LexicalType unitType) {
        this.unitType = unitType;
    }

    @Override
    public LexicalUnit.LexicalType getLexicalUnitType() {
        return this.unitType;
    }

    void setUnitType(LexicalUnit.LexicalType unitType) {
        this.unitType = unitType;
    }

    @Override
    public short getCssUnit() {
        return this.cssUnit;
    }

    void setCssUnit(short cssUnit) {
        this.cssUnit = cssUnit;
    }

    @Override
    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    @Override
    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    @Override
    public void insertNextLexicalUnit(LexicalUnit nextUnit) throws CSSException {
        LexicalUnitImpl lastlu;
        if (nextUnit == null || nextUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            return;
        }
        LexicalUnitImpl nlu = (LexicalUnitImpl)nextUnit;
        if (nlu.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Argument is a parameter of another unit.");
        }
        if (nlu.getPreviousLexicalUnit() != null) {
            throw new IllegalArgumentException("Argument unit has a previous unit.");
        }
        nlu.previousLexicalUnit = this;
        nlu.ownerLexicalUnit = this.ownerLexicalUnit;
        LexicalUnitImpl lu = nlu;
        do {
            lastlu = lu;
        } while ((lu = lu.nextLexicalUnit) != null);
        lastlu.nextLexicalUnit = this.nextLexicalUnit;
        if (this.nextLexicalUnit != null) {
            this.nextLexicalUnit.previousLexicalUnit = lastlu;
        }
        this.nextLexicalUnit = nlu;
    }

    @Override
    public LexicalUnit replaceBy(LexicalUnit replacementUnit) throws CSSBudgetException {
        if (replacementUnit == null || replacementUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            return this.remove();
        }
        LexicalUnitImpl rlu = (LexicalUnitImpl)replacementUnit;
        if (rlu.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Replacement unit is a parameter.");
        }
        if (this.ownerLexicalUnit != null) {
            if (rlu.previousLexicalUnit != null) {
                throw new IllegalArgumentException("Replacement unit has a previous unit.");
            }
            LexicalUnitImpl lu = rlu;
            do {
                lu.ownerLexicalUnit = this.ownerLexicalUnit;
            } while ((lu = lu.nextLexicalUnit) != null);
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = rlu;
            }
            this.ownerLexicalUnit = null;
        }
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = rlu;
            rlu.previousLexicalUnit = this.previousLexicalUnit;
        }
        if (this.nextLexicalUnit != null) {
            LexicalUnitImpl lastlu;
            int counter = 0;
            LexicalUnitImpl lu = rlu;
            do {
                lastlu = lu;
                lu = lu.nextLexicalUnit;
                if (++counter < 262144) continue;
                throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
            } while (lu != null);
            this.nextLexicalUnit.previousLexicalUnit = lastlu;
            lastlu.nextLexicalUnit = this.nextLexicalUnit;
            this.nextLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return replacementUnit;
    }

    @Override
    public int countReplaceBy(LexicalUnit replacementUnit) throws CSSBudgetException {
        if (replacementUnit == null) {
            this.remove();
            return 0;
        }
        return this.countReplaceBy(replacementUnit, 0);
    }

    private int countReplaceBy(LexicalUnit replacementUnit, int counter) throws CSSBudgetException {
        LexicalUnitImpl lu;
        LexicalUnitImpl rlu = (LexicalUnitImpl)replacementUnit;
        if (rlu.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            ++counter;
            LexicalUnitImpl nrlu = rlu.nextLexicalUnit;
            if (nrlu != null) {
                nrlu.previousLexicalUnit = null;
                if ((counter = this.countReplaceBy(nrlu, counter)) >= 262144) {
                    throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
                }
                return counter;
            }
            this.remove();
            return counter;
        }
        if (rlu.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Replacement unit is a parameter.");
        }
        if (this.ownerLexicalUnit != null) {
            if (rlu.previousLexicalUnit != null) {
                throw new IllegalArgumentException("Replacement unit has a previous unit.");
            }
            lu = rlu;
            do {
                lu.ownerLexicalUnit = this.ownerLexicalUnit;
            } while ((lu = lu.nextLexicalUnit) != null);
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = rlu;
            }
            this.ownerLexicalUnit = null;
        }
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = rlu;
            rlu.previousLexicalUnit = this.previousLexicalUnit;
        }
        if (this.nextLexicalUnit != null) {
            LexicalUnitImpl lastlu;
            lu = rlu;
            do {
                lastlu = lu;
                lu = lu.nextLexicalUnit;
                if (++counter < 262144) continue;
                throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
            } while (lu != null);
            this.nextLexicalUnit.previousLexicalUnit = lastlu;
            lastlu.nextLexicalUnit = this.nextLexicalUnit;
            this.nextLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return counter;
    }

    @Override
    public LexicalUnit remove() {
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = this.nextLexicalUnit;
        }
        LexicalUnitImpl rlu = this.nextLexicalUnit;
        if (this.nextLexicalUnit != null) {
            this.nextLexicalUnit.previousLexicalUnit = this.previousLexicalUnit;
            this.nextLexicalUnit = null;
        }
        if (this.ownerLexicalUnit != null) {
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = rlu;
            }
            this.ownerLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return rlu;
    }

    @Override
    public int getIntegerValue() {
        return this.intValue;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    public String getFunctionName() {
        return this.value;
    }

    @Override
    public LexicalUnit getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isParameter() {
        return this.ownerLexicalUnit != null;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public LexicalUnit getSubValues() {
        if (this.unitType == LexicalUnit.LexicalType.SUB_EXPRESSION || this.unitType == LexicalUnit.LexicalType.UNICODE_RANGE) {
            return this.parameters;
        }
        return null;
    }

    void addFunctionParameter(LexicalUnitImpl paramUnit) {
        paramUnit.ownerLexicalUnit = this;
        if (this.parameters == null) {
            this.parameters = paramUnit;
        } else {
            LexicalUnit lu = this.parameters;
            while (lu.getNextLexicalUnit() != null) {
                lu = lu.getNextLexicalUnit();
            }
            LexicalUnitImpl luimpl = lu;
            luimpl.nextLexicalUnit = paramUnit;
            paramUnit.previousLexicalUnit = luimpl;
        }
    }

    void reset() {
        this.intValue = 0;
        this.floatValue = 0.0f;
        this.dimensionUnitText = "";
        this.parameters = null;
        this.nextLexicalUnit = null;
    }

    @Override
    public String getCssText() {
        return this.currentToString().toString();
    }

    public String toString() {
        if (this.nextLexicalUnit == null) {
            return this.currentToString().toString();
        }
        StringBuilder buf = new StringBuilder();
        LexicalUnitImpl lu = this;
        boolean needSpaces = false;
        while (lu != null) {
            switch (lu.getLexicalUnitType()) {
                case OPERATOR_EXP: 
                case OPERATOR_GE: 
                case OPERATOR_GT: 
                case OPERATOR_LE: 
                case OPERATOR_LT: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_SLASH: 
                case OPERATOR_TILDE: 
                case LEFT_BRACKET: 
                case EMPTY: {
                    needSpaces = false;
                }
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    break;
                }
                case RIGHT_BRACKET: {
                    needSpaces = true;
                    break;
                }
                default: {
                    if (needSpaces) {
                        buf.append(' ');
                        break;
                    }
                    needSpaces = true;
                }
            }
            buf.append(lu.currentToString());
            lu = lu.nextLexicalUnit;
        }
        return buf.toString();
    }

    CharSequence currentToString() {
        switch (this.unitType) {
            case INTEGER: {
                return Integer.toString(this.intValue);
            }
            case PERCENTAGE: 
            case REAL: 
            case DIMENSION: {
                StringBuilder buf = new StringBuilder();
                if (this.floatValue % 1.0f != 0.0f) {
                    buf.append(String.format(Locale.ROOT, "%s", Float.valueOf(this.floatValue)));
                } else {
                    buf.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(this.floatValue)));
                }
                if (this.dimensionUnitText != null) {
                    buf.append(this.dimensionUnitText);
                }
                return buf;
            }
            case RGBCOLOR: {
                if (this.identCssText != null) {
                    return this.identCssText;
                }
            }
            case FUNCTION: 
            case MATH_FUNCTION: {
                return this.functionalSerialization(this.value);
            }
            case CALC: 
            case RECT_FUNCTION: 
            case VAR: 
            case ATTR: 
            case SRC: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: 
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: 
            case CUBIC_BEZIER_FUNCTION: 
            case STEPS_FUNCTION: 
            case TYPE_FUNCTION: {
                return this.functionalSerialization(this.value.toLowerCase(Locale.ROOT));
            }
            case SUB_EXPRESSION: {
                StringBuilder buf = new StringBuilder();
                buf.append('(');
                LexicalUnitImpl lu = this.parameters;
                if (lu != null) {
                    buf.append(((Object)lu).toString());
                }
                buf.append(')');
                return buf;
            }
            case IDENT: {
                return this.identCssText != null ? this.identCssText : this.value;
            }
            case STRING: {
                return this.identCssText;
            }
            case URI: {
                String quri = this.identCssText != null ? this.identCssText : (this.value != null ? ParseHelper.quote(this.value, '\'') : (this.parameters != null ? this.parameters.getCssText() : ""));
                return "url(" + quri + ")";
            }
            case INHERIT: {
                return "inherit";
            }
            case INITIAL: {
                return "initial";
            }
            case UNSET: {
                return "unset";
            }
            case REVERT: {
                return "revert";
            }
            case ELEMENT_REFERENCE: {
                if (this.value == null) {
                    if (this.parameters == null) {
                        return "element(#)";
                    }
                    return this.functionalSerialization("element");
                }
                int len = this.value.length();
                StringBuilder buf = new StringBuilder(len + 10);
                buf.append("element(#").append(this.value).append(')');
                return buf;
            }
            case UNICODE_RANGE: {
                StringBuilder buf = new StringBuilder();
                LexicalUnit lu = this.parameters;
                if (lu != null) {
                    if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                        buf.append("U+").append(Integer.toHexString(lu.getIntegerValue()));
                    } else {
                        buf.append("U+").append(lu.getStringValue());
                    }
                    lu = lu.getNextLexicalUnit();
                    if (lu != null) {
                        buf.append('-');
                        if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                            buf.append(Integer.toHexString(lu.getIntegerValue()));
                        } else {
                            buf.append(lu.getStringValue());
                        }
                    }
                }
                return buf;
            }
            case UNICODE_WILDCARD: {
                return this.getStringValue();
            }
            case OPERATOR_COMMA: {
                return ",";
            }
            case OPERATOR_SEMICOLON: {
                return ";";
            }
            case OPERATOR_EXP: {
                return "^";
            }
            case OPERATOR_GE: {
                return ">=";
            }
            case OPERATOR_GT: {
                return ">";
            }
            case OPERATOR_LE: {
                return "<=";
            }
            case OPERATOR_LT: {
                return "<";
            }
            case OPERATOR_MINUS: {
                return "-";
            }
            case OPERATOR_MOD: {
                return "%";
            }
            case OPERATOR_MULTIPLY: {
                return "*";
            }
            case OPERATOR_PLUS: {
                return "+";
            }
            case OPERATOR_SLASH: {
                return "/";
            }
            case OPERATOR_TILDE: {
                return "~";
            }
            case LEFT_BRACKET: {
                return "[";
            }
            case RIGHT_BRACKET: {
                return "]";
            }
            case COMPAT_IDENT: 
            case COMPAT_PRIO: {
                return ParseHelper.escapeControl(this.value);
            }
        }
        return "";
    }

    private CharSequence functionalSerialization(String fname) {
        StringBuilder buf = new StringBuilder();
        buf.append(fname).append('(');
        LexicalUnitImpl lu = this.parameters;
        if (lu != null) {
            buf.append(((Object)lu).toString());
        }
        buf.append(')');
        return buf;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        if (syntax != null) {
            switch (this.getLexicalUnitType()) {
                case INHERIT: 
                case INITIAL: 
                case UNSET: 
                case REVERT: {
                    return this.nextLexicalUnit == null ? CSSValueSyntax.Match.PENDING : CSSValueSyntax.Match.FALSE;
                }
            }
            CSSValueSyntax comp = syntax;
            do {
                CSSValueSyntax.Match result;
                CSSValueSyntax.Multiplier mult = comp.getMultiplier();
                CSSValueSyntax.Category cat = comp.getCategory();
                if (cat == CSSValueSyntax.Category.universal) {
                    return CSSValueSyntax.Match.TRUE;
                }
                if (mult == CSSValueSyntax.Multiplier.NONE && this.nextLexicalUnit != null && cat != CSSValueSyntax.Category.transformList || (result = this.matchesComponent(syntax, comp)) == CSSValueSyntax.Match.FALSE) continue;
                return result;
            } while ((comp = comp.getNext()) != null);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private CSSValueSyntax.Match matchesComponent(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Match prevmatch;
        block4: {
            LexicalUnitImpl lu = this;
            prevmatch = CSSValueSyntax.Match.FALSE;
            while (true) {
                CSSValueSyntax.Match match;
                if ((match = LexicalUnitImpl.matchesComponent(lu, rootSyntax, syntax)) == CSSValueSyntax.Match.FALSE) {
                    return CSSValueSyntax.Match.FALSE;
                }
                if (prevmatch != CSSValueSyntax.Match.PENDING) {
                    prevmatch = match;
                }
                if ((lu = lu.nextLexicalUnit) == null) break block4;
                if (syntax.getMultiplier() != CSSValueSyntax.Multiplier.NUMBER) continue;
                if (lu.unitType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lu = lu.nextLexicalUnit;
                    if (lu != null) continue;
                    break block4;
                }
                if (syntax.getCategory() != CSSValueSyntax.Category.transformList && lu.unitType != LexicalUnit.LexicalType.VAR && lu.previousLexicalUnit.unitType != LexicalUnit.LexicalType.VAR) break;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        return prevmatch;
    }

    private static CSSValueSyntax.Match matchesComponent(LexicalUnitImpl lexicalUnit, CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        LexicalUnit.LexicalType type = lexicalUnit.getLexicalUnitType();
        switch (type) {
            case OPERATOR_COMMA: {
                if (syntax.getMultiplier() != CSSValueSyntax.Multiplier.NUMBER || lexicalUnit.nextLexicalUnit == null) {
                    return CSSValueSyntax.Match.FALSE;
                }
                return CSSValueSyntax.Match.TRUE;
            }
            case OPERATOR_EXP: 
            case OPERATOR_GE: 
            case OPERATOR_GT: 
            case OPERATOR_LE: 
            case OPERATOR_LT: 
            case OPERATOR_MULTIPLY: 
            case OPERATOR_SLASH: 
            case OPERATOR_TILDE: 
            case OPERATOR_SEMICOLON: 
            case INHERIT: 
            case INITIAL: 
            case UNSET: 
            case REVERT: 
            case OPERATOR_MINUS: 
            case OPERATOR_MOD: 
            case OPERATOR_PLUS: {
                return CSSValueSyntax.Match.FALSE;
            }
        }
        CSSValueSyntax.Category cat = syntax.getCategory();
        if (cat == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        switch (type) {
            case IDENT: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.customIdent || cat == CSSValueSyntax.Category.IDENT && syntax.getName().equals(lexicalUnit.getStringValue()) || cat == CSSValueSyntax.Category.color && ColorIdentifiers.getInstance().isColorIdentifier(lexicalUnit.getStringValue().toLowerCase(Locale.ROOT)));
            }
            case STRING: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.string);
            }
            case ATTR: {
                return LexicalUnitImpl.matchAttr(lexicalUnit, rootSyntax, syntax);
            }
            case SRC: 
            case URI: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.url || cat == CSSValueSyntax.Category.image);
            }
            case DIMENSION: {
                return LexicalUnitImpl.matchBoolean(LexicalUnitImpl.unitMatchesCategory(lexicalUnit.getCssUnit(), cat));
            }
            case PERCENTAGE: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.percentage || cat == CSSValueSyntax.Category.lengthPercentage);
            }
            case REAL: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.number);
            }
            case INTEGER: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.integer || cat == CSSValueSyntax.Category.number);
            }
            case RGBCOLOR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.color);
            }
            case CALC: {
                return LexicalUnitImpl.isNumericCategory(cat) ? LexicalUnitImpl.matchExpression(lexicalUnit, rootSyntax, syntax) : CSSValueSyntax.Match.FALSE;
            }
            case FUNCTION: {
                return LexicalUnitImpl.matchFunction(lexicalUnit, rootSyntax, syntax);
            }
            case MATH_FUNCTION: {
                if (LexicalUnitImpl.isNumericCategory(cat)) {
                    Dimension dim;
                    DimensionalAnalyzer danal = new DimensionalAnalyzer();
                    try {
                        dim = ((MathFunctionUnitImpl)lexicalUnit).dimension(danal);
                    }
                    catch (DOMException e) {
                        return CSSValueSyntax.Match.FALSE;
                    }
                    return dim != null ? dim.matches(syntax) : CSSValueSyntax.Match.PENDING;
                }
                return CSSValueSyntax.Match.FALSE;
            }
            case ELEMENT_REFERENCE: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.image);
            }
            case VAR: {
                return CSSValueSyntax.Match.PENDING;
            }
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.counter);
            }
            case UNICODE_RANGE: 
            case UNICODE_WILDCARD: {
                return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.unicodeRange);
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private static CSSValueSyntax.Match matchBoolean(boolean b) {
        return b ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    private static boolean unitMatchesCategory(short unit, CSSValueSyntax.Category cat) {
        switch (cat) {
            case length: {
                return CSSUnit.isLengthUnitType(unit);
            }
            case lengthPercentage: {
                return CSSUnit.isLengthUnitType(unit) || unit == 2;
            }
            case percentage: {
                return unit == 2;
            }
            case angle: {
                return CSSUnit.isAngleUnitType(unit);
            }
            case time: {
                return CSSUnit.isTimeUnitType(unit);
            }
            case resolution: {
                return CSSUnit.isResolutionUnitType(unit);
            }
            case flex: {
                return unit == 70;
            }
            case frequency: {
                return unit == 100 || unit == 101;
            }
            case integer: 
            case number: {
                return unit == 0;
            }
        }
        return false;
    }

    private static CSSValueSyntax.Match matchAttr(LexicalUnitImpl lexicalUnit, CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Match result = CSSValueSyntax.Match.FALSE;
        LexicalUnit param = lexicalUnit.getParameters();
        if (param != null) {
            LexicalUnit fallback = null;
            if ((param = param.getNextLexicalUnit()) == null) {
                return syntax.getCategory() == CSSValueSyntax.Category.string ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            short unit = 1;
            CSSValueSyntax attrSyntax = null;
            LexicalUnit.LexicalType luType = param.getLexicalUnitType();
            if (luType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                attrSyntax = SyntaxParser.createSimpleSyntax("string");
                fallback = param.getNextLexicalUnit();
            } else {
                switch (luType) {
                    case OPERATOR_COMMA: {
                        break;
                    }
                    case TYPE_FUNCTION: {
                        LexicalUnit typeParam = param.getParameters();
                        try {
                            attrSyntax = typeParam.getSyntax();
                            break;
                        }
                        catch (IllegalStateException e) {
                            return CSSValueSyntax.Match.FALSE;
                        }
                    }
                    case IDENT: {
                        String s = param.getStringValue().toLowerCase(Locale.ROOT);
                        if ("string".equals(s)) {
                            attrSyntax = SyntaxParser.createSimpleSyntax("string");
                            break;
                        }
                        unit = UnitStringToId.unitFromString(s);
                        break;
                    }
                    case OPERATOR_MOD: {
                        unit = 2;
                        break;
                    }
                    case VAR: {
                        return CSSValueSyntax.Match.PENDING;
                    }
                    default: {
                        return CSSValueSyntax.Match.FALSE;
                    }
                }
                param = param.getNextLexicalUnit();
                if (param != null) {
                    if (param.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        return CSSValueSyntax.Match.FALSE;
                    }
                    fallback = param.getNextLexicalUnit();
                }
            }
            CSSValueSyntax typeMatch = null;
            CSSValueSyntax comp = rootSyntax;
            block9: do {
                CSSValueSyntax.Match attrTypeMatch;
                if (attrSyntax == null) {
                    if (LexicalUnitImpl.unitMatchesCategory(unit, comp.getCategory())) {
                        attrTypeMatch = CSSValueSyntax.Match.TRUE;
                        result = CSSValueSyntax.Match.PENDING;
                        typeMatch = comp;
                    } else {
                        attrTypeMatch = CSSValueSyntax.Match.FALSE;
                    }
                } else {
                    attrTypeMatch = LexicalUnitImpl.matchAttrTypeSyntax(lexicalUnit.isParameter(), attrSyntax, comp.getCategory());
                    if (attrTypeMatch != CSSValueSyntax.Match.FALSE) {
                        result = CSSValueSyntax.Match.PENDING;
                        typeMatch = comp;
                    }
                }
                if (fallback != null) {
                    CSSValueSyntax fallbackComp = rootSyntax;
                    do {
                        CSSValueSyntax.Match match;
                        if ((match = fallback.matches(fallbackComp)) == CSSValueSyntax.Match.FALSE) {
                            if (attrTypeMatch == CSSValueSyntax.Match.FALSE || attrSyntax == null || attrSyntax.getCategory() != CSSValueSyntax.Category.url || fallback.getLexicalUnitType() != LexicalUnit.LexicalType.STRING || !LexicalUnitImpl.hasNoSiblings(lexicalUnit) || fallback.getNextLexicalUnit() != null) continue;
                            result = CSSValueSyntax.Match.TRUE;
                        } else if (match == CSSValueSyntax.Match.PENDING) {
                            result = CSSValueSyntax.Match.PENDING;
                            if (attrTypeMatch != CSSValueSyntax.Match.FALSE) {
                                continue;
                            }
                        } else {
                            if (attrTypeMatch != CSSValueSyntax.Match.TRUE) {
                                result = CSSValueSyntax.Match.PENDING;
                                continue block9;
                            }
                            if (LexicalUnitImpl.hasNoSiblings(lexicalUnit) || typeMatch == fallbackComp) {
                                result = CSSValueSyntax.Match.TRUE;
                            }
                        }
                        return result;
                    } while ((fallbackComp = fallbackComp.getNext()) != null);
                    continue;
                }
                if (attrTypeMatch != CSSValueSyntax.Match.TRUE) continue;
                return CSSValueSyntax.Match.TRUE;
            } while ((comp = comp.getNext()) != null);
        }
        return result;
    }

    private static CSSValueSyntax.Match matchAttrTypeSyntax(boolean calcContext, CSSValueSyntax typeSyntax, CSSValueSyntax.Category cat) {
        CSSValueSyntax.Match expected = CSSValueSyntax.Match.FALSE;
        do {
            CSSValueSyntax.Category typeCategory;
            CSSValueSyntax.Match match;
            if ((match = LexicalUnitImpl.categoryMatch(calcContext, false, typeCategory = typeSyntax.getCategory(), cat)) != CSSValueSyntax.Match.FALSE) {
                if (expected == CSSValueSyntax.Match.PENDING) continue;
                expected = CSSValueSyntax.Match.TRUE;
                break;
            }
            if (expected != CSSValueSyntax.Match.TRUE) continue;
            expected = CSSValueSyntax.Match.PENDING;
        } while ((typeSyntax = typeSyntax.getNext()) != null);
        return expected;
    }

    private static CSSValueSyntax.Match matchExpression(LexicalUnitImpl lunit, CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        Dimension dim;
        DimensionalAnalyzer danal = new DimensionalAnalyzer();
        try {
            dim = danal.expressionDimension(lunit.parameters);
        }
        catch (DOMException e) {
            return CSSValueSyntax.Match.FALSE;
        }
        if (dim == null) {
            return CSSValueSyntax.Match.PENDING;
        }
        CSSValueSyntax.Match expected = CSSValueSyntax.Match.FALSE;
        boolean lenghtMatched = false;
        boolean pcntMatched = false;
        CSSValueSyntax comp = rootSyntax;
        do {
            CSSValueSyntax.Match match;
            CSSValueSyntax.Category cat = comp.getCategory();
            boolean lenientLP = danal.isAttrPending();
            if (lenientLP) {
                match = LexicalUnitImpl.categoryMatch(true, true, dim.category, cat);
                if (match == CSSValueSyntax.Match.PENDING) {
                    if (cat == CSSValueSyntax.Category.length) {
                        lenghtMatched = true;
                        match = dim.isPercentageProcessed() ? CSSValueSyntax.Match.FALSE : CSSValueSyntax.Match.PENDING;
                    } else if (cat == CSSValueSyntax.Category.percentage) {
                        pcntMatched = true;
                        match = dim.isLengthProcessed() ? CSSValueSyntax.Match.FALSE : CSSValueSyntax.Match.PENDING;
                    }
                }
            } else {
                if (cat == CSSValueSyntax.Category.length) {
                    lenghtMatched = true;
                } else if (cat == CSSValueSyntax.Category.percentage) {
                    pcntMatched = true;
                }
                match = LexicalUnitImpl.categoryMatch(true, false, dim.category, cat);
            }
            if (match == CSSValueSyntax.Match.TRUE) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (expected == CSSValueSyntax.Match.PENDING) continue;
            expected = match;
        } while ((comp = comp.getNext()) != null);
        if (dim.category == CSSValueSyntax.Category.lengthPercentage && lenghtMatched && pcntMatched) {
            expected = CSSValueSyntax.Match.TRUE;
        }
        return expected;
    }

    private static CSSValueSyntax.Match categoryMatch(boolean calcContext, boolean lenientLP, CSSValueSyntax.Category typeCategory, CSSValueSyntax.Category cat) {
        if (typeCategory == cat || typeCategory == CSSValueSyntax.Category.length && cat == CSSValueSyntax.Category.lengthPercentage || typeCategory == CSSValueSyntax.Category.percentage && cat == CSSValueSyntax.Category.lengthPercentage || typeCategory == CSSValueSyntax.Category.integer && cat == CSSValueSyntax.Category.number || calcContext && typeCategory == CSSValueSyntax.Category.number && cat == CSSValueSyntax.Category.integer || typeCategory == CSSValueSyntax.Category.url && cat == CSSValueSyntax.Category.image || cat == CSSValueSyntax.Category.url && typeCategory == CSSValueSyntax.Category.image) {
            return CSSValueSyntax.Match.TRUE;
        }
        if (lenientLP && (typeCategory == CSSValueSyntax.Category.lengthPercentage && cat == CSSValueSyntax.Category.length || typeCategory == CSSValueSyntax.Category.lengthPercentage && cat == CSSValueSyntax.Category.percentage)) {
            return CSSValueSyntax.Match.PENDING;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private static boolean hasNoSiblings(LexicalUnit lexicalUnit) {
        return lexicalUnit.getNextLexicalUnit() == null && lexicalUnit.getPreviousLexicalUnit() == null;
    }

    private static CSSValueSyntax.Match matchFunction(LexicalUnitImpl lexicalUnit, CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Category cat = syntax.getCategory();
        String func = lexicalUnit.getFunctionName().toLowerCase(Locale.ROOT);
        if (func.endsWith("-gradient") || func.equals("image") || func.equals("image-set") || func.equals("cross-fade")) {
            return LexicalUnitImpl.matchBoolean(cat == CSSValueSyntax.Category.image);
        }
        if (func.equals("env")) {
            return CSSValueSyntax.Match.PENDING;
        }
        return LexicalUnitImpl.matchBoolean((cat == CSSValueSyntax.Category.transformFunction || cat == CSSValueSyntax.Category.transformList) && ParseHelper.isTransformFunction(func));
    }

    private static boolean isNumericCategory(CSSValueSyntax.Category cat) {
        switch (cat) {
            case length: 
            case lengthPercentage: 
            case percentage: 
            case angle: 
            case time: 
            case resolution: 
            case flex: 
            case frequency: 
            case integer: 
            case number: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.unitType.hashCode();
        result = 31 * result + this.cssUnit;
        result = 31 * result + (this.dimensionUnitText == null ? 0 : this.dimensionUnitText.hashCode());
        result = 31 * result + Float.floatToIntBits(this.floatValue);
        result = 31 * result + this.intValue;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        LexicalUnitImpl lu = this.parameters;
        while (lu != null) {
            result = 31 * result + lu.hashCode();
            lu = lu.nextLexicalUnit;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LexicalUnitImpl other = (LexicalUnitImpl)obj;
        if (this.unitType != other.unitType) {
            return false;
        }
        if (this.cssUnit != other.cssUnit) {
            return false;
        }
        if (this.dimensionUnitText == null ? other.dimensionUnitText != null : !this.dimensionUnitText.equals(other.dimensionUnitText)) {
            return false;
        }
        if (Float.floatToIntBits(this.floatValue) != Float.floatToIntBits(other.floatValue)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.intValue != other.intValue) {
            return false;
        }
        if (this.parameters == null) {
            return other.parameters == null;
        }
        if (other.parameters == null) {
            return false;
        }
        LexicalUnitImpl lu = this.parameters;
        LexicalUnitImpl olu = other.parameters;
        while (lu != null) {
            if (!lu.equals(olu)) {
                return false;
            }
            lu = lu.nextLexicalUnit;
            olu = olu.nextLexicalUnit;
        }
        return olu == null;
    }

    @Override
    public LexicalUnitImpl shallowClone() {
        LexicalUnitImpl clon = this.instantiateLexicalUnit();
        clon.cssUnit = this.cssUnit;
        clon.intValue = this.intValue;
        clon.floatValue = this.floatValue;
        clon.dimensionUnitText = this.dimensionUnitText;
        clon.identCssText = this.identCssText;
        clon.value = this.value;
        if (this.parameters != null) {
            clon.parameters = this.parameters.clone(clon);
        }
        return clon;
    }

    LexicalUnitImpl instantiateLexicalUnit() {
        return new LexicalUnitImpl(this.unitType);
    }

    @Override
    public LexicalUnitImpl clone() {
        return this.clone(null);
    }

    private LexicalUnitImpl clone(LexicalUnitImpl newOwner) {
        LexicalUnitImpl clon = this.shallowClone();
        if (this.nextLexicalUnit != null) {
            clon.nextLexicalUnit = this.nextLexicalUnit.clone(newOwner);
            clon.nextLexicalUnit.previousLexicalUnit = clon;
        }
        clon.ownerLexicalUnit = newOwner;
        return clon;
    }
}

