/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.DOMException;

public abstract class ColorValue
extends TypedValue
implements CSSColorValue {
    private static final long serialVersionUID = 1L;
    static final NumberValue opaqueAlpha;
    private boolean systemDefault = false;
    boolean commaSyntax = true;

    ColorValue() {
        super(CSSValue.Type.COLOR);
    }

    ColorValue(CSSValue.Type unitType) {
        super(unitType);
    }

    ColorValue(ColorValue copied) {
        super(copied);
        this.systemDefault = copied.systemDefault;
        this.commaSyntax = copied.commaSyntax;
    }

    public void setSystemDefault() {
        this.systemDefault = true;
    }

    @Override
    public boolean isSystemDefault() {
        return this.systemDefault;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue value = factory.parseProperty(cssText);
        if (value.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSValue.Type ptype = value.getPrimitiveType();
            if (ptype == CSSValue.Type.IDENT) {
                String ident = ((CSSTypedValue)((Object)value)).getStringValue().toLowerCase(Locale.ROOT);
                String colorspec = ColorIdentifiers.getInstance().getColor(ident);
                if (colorspec != null) {
                    value = factory.parseProperty(colorspec);
                } else if ("transparent".equals(ident)) {
                    value = factory.parseProperty("rgba(0,0,0,0)");
                } else {
                    this.failSetCssText();
                }
                ptype = value.getPrimitiveType();
            }
            if (ptype != CSSValue.Type.COLOR || ((ColorValue)value).getColorModel() != this.getColorModel() || !((ColorValue)value).getColor().getColorSpace().equals(this.getColor().getColorSpace()) || this.getClass() != value.getClass()) {
                this.failSetCssText();
            }
            this.set(value);
        } else {
            this.failSetCssText();
        }
    }

    private void failSetCssText() {
        throw new DOMException(13, "This value can only be set to a color in the original color space and the " + (Object)((Object)this.getColorModel()) + " color model, using the same syntax.");
    }

    void set(StyleValue value) {
        ColorValue setfrom = (ColorValue)value;
        this.systemDefault = setfrom.systemDefault;
        this.commaSyntax = setfrom.commaSyntax;
    }

    @Override
    public String getCssText() {
        return this.getColor().toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.getColor().toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getColor().toString());
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LABColor lab1;
        LABColor lab2;
        if (!this.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LCH: 
            case LAB: 
            case XYZ: {
                return color.deltaE2000(this);
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rgbcolor.toLABColor(labColor);
                lab2 = labColor;
                RGBAColor color1 = this.toRGBColor(false);
                RGBColorValue rgb1 = new RGBColorValue();
                rgb1.setComponent(0, (StyleValue)((Object)color1.getAlpha()));
                rgb1.setComponent(1, (StyleValue)((Object)color1.getRed()));
                rgb1.setComponent(2, (StyleValue)((Object)color1.getGreen()));
                rgb1.setComponent(3, (StyleValue)((Object)color1.getBlue()));
                lab1 = rgb1.toLABColorValue().getColor();
                break;
            }
            default: {
                RGBAColor color1 = this.toRGBColor(false);
                RGBAColor color2 = color.toRGBColor(false);
                RGBColorValue rgb1 = new RGBColorValue();
                RGBColorValue rgb2 = new RGBColorValue();
                rgb1.setComponent(0, (StyleValue)((Object)color1.getAlpha()));
                rgb1.setComponent(1, (StyleValue)((Object)color1.getRed()));
                rgb1.setComponent(2, (StyleValue)((Object)color1.getGreen()));
                rgb1.setComponent(3, (StyleValue)((Object)color1.getBlue()));
                rgb2.setComponent(0, (StyleValue)((Object)color2.getAlpha()));
                rgb2.setComponent(1, (StyleValue)((Object)color2.getRed()));
                rgb2.setComponent(2, (StyleValue)((Object)color2.getGreen()));
                rgb2.setComponent(3, (StyleValue)((Object)color2.getBlue()));
                lab1 = rgb1.toLABColorValue().getColor();
                lab2 = rgb2.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)lab1.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab1.getA()).getFloatValue((short)0), ((CSSTypedValue)lab1.getB()).getFloatValue((short)0), ((CSSTypedValue)lab2.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab2.getA()).getFloatValue((short)0), ((CSSTypedValue)lab2.getB()).getFloatValue((short)0));
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        return syntax.getCategory() == CSSValueSyntax.Category.color ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    @Override
    public void setComponent(int index, StyleValue component) {
    }

    @Override
    public abstract PrimitiveValue getComponent(int var1);

    @Override
    public int getComponentCount() {
        return this.getColor().getLength();
    }

    abstract boolean hasConvertibleComponents();

    @Override
    public abstract ColorValue clone();

    public HSLColorValue toHSLColorValue() throws DOMException {
        RGBColor rgb = (RGBColor)this.toRGBColor(false);
        HSLColorValue hsl = new HSLColorValue();
        rgb.toHSLColor(hsl.getHSLColorImpl());
        return hsl;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        RGBColor rgb = (RGBColor)this.toRGBColor(false);
        LABColorValue lab = new LABColorValue();
        rgb.toLABColor(lab.getLABColorImpl());
        return lab;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        return this.toLABColorValue().toLCHColorValue();
    }

    static {
        NumberValue alpha = new NumberValue();
        alpha.setFloatValue((short)0, 1.0f);
        opaqueAlpha = alpha.immutable();
    }

    class MyHSLColorImpl
    extends HSLColorImpl {
        private static final long serialVersionUID = 1L;

        MyHSLColorImpl() {
        }

        @Override
        public String toString() {
            return this.toString(ColorValue.this.commaSyntax);
        }
    }

    class CSSRGBColor
    extends RGBColor {
        private static final long serialVersionUID = 2L;

        CSSRGBColor() {
        }

        CSSRGBColor(CSSRGBColor copyMe) {
            super(copyMe);
        }

        @Override
        public String toString() {
            return this.toString(false);
        }

        @Override
        public String toMinifiedString() {
            return this.toString(true);
        }

        String toString(boolean minify) {
            StringBuilder buf;
            float fr = this.componentByte(this.getRed());
            float fg = this.componentByte(this.getGreen());
            float fb = this.componentByte(this.getBlue());
            boolean nonOpaque = this.isNonOpaque();
            if (nonOpaque || !this.isInteger(fr) || !this.isInteger(fg) || !this.isInteger(fb) || fr > 255.0f || fg > 255.0f || fb > 255.0f) {
                if (minify) {
                    if (ColorValue.this.commaSyntax) {
                        return this.minifiedOldFunctionalString(nonOpaque);
                    }
                    return this.minifiedFunctionalString(nonOpaque);
                }
                if (ColorValue.this.commaSyntax) {
                    return this.oldFunctionalString(nonOpaque);
                }
                return this.functionalString(nonOpaque);
            }
            int r = Math.round(fr);
            int g = Math.round(fg);
            int b = Math.round(fb);
            String hexr = Integer.toHexString(r);
            String hexg = Integer.toHexString(g);
            String hexb = Integer.toHexString(b);
            if (r != 0 && this.notSameChar(hexr) || g != 0 && this.notSameChar(hexg) || b != 0 && this.notSameChar(hexb)) {
                buf = new StringBuilder(7);
                buf.append('#');
                if (hexr.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexr);
                if (hexg.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexg);
                if (hexb.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexb);
            } else {
                buf = new StringBuilder(4);
                buf.append('#');
                buf.append(hexr.charAt(0));
                buf.append(hexg.charAt(0));
                buf.append(hexb.charAt(0));
            }
            return buf.toString();
        }

        private float componentByte(PrimitiveValue component) {
            TypedValue number;
            CSSValue.Type type = component.getPrimitiveType();
            float byteComp = type == CSSValue.Type.NUMERIC ? ((number = (TypedValue)component).getUnitType() == 2 ? number.getFloatValue((short)2) * 2.55f : number.getFloatValue((short)0)) : 256.0f;
            return byteComp;
        }

        private boolean isInteger(float r) {
            return (double)Math.abs(r - (float)Math.rint(r)) < 3.0E-4;
        }

        private String minifiedFunctionalString(boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(21);
            buf.append("rgb(");
            this.appendComponentMinifiedCssText(buf, this.getRed()).append(' ');
            this.appendComponentMinifiedCssText(buf, this.getGreen()).append(' ');
            this.appendComponentMinifiedCssText(buf, this.getBlue());
            if (nonOpaque) {
                buf.append('/');
                this.appendAlphaChannelMinified(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private String functionalString(boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(23);
            buf.append("rgb(");
            this.appendComponentCssText(buf, this.getRed()).append(' ');
            this.appendComponentCssText(buf, this.getGreen()).append(' ');
            this.appendComponentCssText(buf, this.getBlue());
            if (nonOpaque) {
                buf.append(" / ");
                this.appendAlphaChannel(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private boolean notSameChar(String hexr) {
            return hexr.length() == 1 || hexr.charAt(0) != hexr.charAt(1);
        }

        @Override
        HSLColorImpl createHSLColor() {
            return new MyHSLColorImpl();
        }

        @Override
        public CSSRGBColor clone() {
            return new CSSRGBColor(this);
        }
    }
}

