/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSEnvVariableValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class EnvVariableValue
extends ProxyValue
implements CSSEnvVariableValue {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private StyleValue fallback = null;

    EnvVariableValue() {
        super(CSSValue.Type.ENV);
    }

    protected EnvVariableValue(EnvVariableValue copied) {
        super(copied);
        this.name = copied.name;
        if (copied.fallback != null) {
            this.fallback = copied.fallback.clone();
        }
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.fallback != null) {
            buf.append(", ").append(this.fallback.getCssText());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.fallback != null) {
            buf.append(',').append(this.fallback.getMinifiedCssText(propertyName));
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"env(");
        wri.write((CharSequence)this.name);
        if (this.fallback != null) {
            wri.write((CharSequence)", ");
            this.fallback.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getPrimitiveType() != CSSValue.Type.ENV) {
            throw new DOMException(13, "Not an environment variable value.");
        }
        EnvVariableValue env = (EnvVariableValue)cssval;
        this.name = env.getName();
        this.fallback = env.fallback;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvVariableValue other = (EnvVariableValue)obj;
        if (this.fallback == null ? other.fallback != null : !this.fallback.equals(other.fallback)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StyleValue getFallback() {
        return this.fallback;
    }

    @Override
    public EnvVariableValue clone() {
        return new EnvVariableValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(EnvVariableValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            EnvVariableValue.this.name = lu.getStringValue();
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                LexicalUnit.LexicalType type = lu.getLexicalUnitType();
                lu = lu.getNextLexicalUnit();
                if (type != LexicalUnit.LexicalType.OPERATOR_COMMA || lu == null) {
                    throw new DOMException(5, "Unexpected character");
                }
                ValueFactory factory = new ValueFactory();
                EnvVariableValue.this.fallback = factory.createCSSValue(lu);
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

