/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GEdgeWeightMetric;
import ghidra.graph.algo.DijkstraShortestPathsAlgorithm;
import ghidra.graph.algo.SorterException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class TopologicalSorter<V, E extends GEdge<V>> {
    private final GDirectedGraph<V, E> graph;
    private boolean requireTotal;
    private final LinkedList<V> list;
    private final Deque<V> unmarked;

    public TopologicalSorter(GDirectedGraph<V, E> graph, boolean requireTotal) {
        this.graph = graph;
        this.requireTotal = requireTotal;
        this.list = new LinkedList();
        this.unmarked = new LinkedList<V>(graph.getVertices());
    }

    public List<V> sort() throws SorterException {
        if (this.requireTotal) {
            this.checkTotal();
        }
        V n;
        while ((n = this.unmarked.peek()) != null) {
            this.visit(n);
        }
        return this.list;
    }

    protected void checkTotal() throws SorterException {
        DijkstraShortestPathsAlgorithm dijkstra = new DijkstraShortestPathsAlgorithm(this.graph, GEdgeWeightMetric.unitMetric());
        for (Object v1 : this.graph.getVertices()) {
            for (Object v2 : this.graph.getVertices()) {
                Double distF = (Double)dijkstra.getDistancesFromSource(v1).get(v2);
                Double distR = (Double)dijkstra.getDistancesFromSource(v2).get(v1);
                if (distF != null || distR != null) continue;
                throw new SorterException("Not a total order", v1, v2);
            }
        }
    }

    protected void visit(V n) throws SorterException {
        this.visit(n, new LinkedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visit(V n, Deque<V> temp) throws SorterException {
        if (temp.contains(n)) {
            throw new SorterException("Graph is cyclic", temp);
        }
        if (this.unmarked.contains(n)) {
            temp.push(n);
            try {
                for (Object m : this.graph.getSuccessors(n)) {
                    this.visit(m, temp);
                }
                this.unmarked.remove(n);
            }
            finally {
                temp.pop();
            }
            this.list.push(n);
        }
    }
}

