/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.bsfv.BSimFeatureVisualizerPlugin;
import ghidra.bsfv.BsfvRowObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class BsfvTokenHighlightMatcher
implements CTokenHighlightMatcher {
    private static final Color DEFAULT_HIGHLIGHT = GThemeDefaults.Colors.Palette.ORANGE;
    private static final Color LINE_HIGHLIGHT_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"lightskyblue");
    private static final Color SECONDARY_LINE_HIGHLIGHT_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"steelblue");
    private PcodeOpAST pcodeOp;
    private PcodeOpAST previousPcodeOp;
    private PcodeBlockBasic block;
    private Set<Integer> lineHighlights;
    private Set<Integer> secondaryLineHighlights;
    private Set<Integer> blockHighlights;
    private Options graphOptions;

    public BsfvTokenHighlightMatcher(BsfvRowObject row, HighFunction highFunction, BSimFeatureVisualizerPlugin plugin) {
        this.graphOptions = plugin.getTool().getOptions("Graph").getOptions("BSim Feature Graph");
        switch (row.getBSimFeatureType()) {
            case DATA_FLOW: {
                this.pcodeOp = row.getPcodeOpAST();
                break;
            }
            case COPY_SIG: 
            case CONTROL_FLOW: {
                this.block = (PcodeBlockBasic)highFunction.getBasicBlocks().get(row.getBlockIndex());
                break;
            }
            case COMBINED: {
                this.block = (PcodeBlockBasic)highFunction.getBasicBlocks().get(row.getBlockIndex());
                this.pcodeOp = row.getPcodeOpAST();
                break;
            }
            case DUAL_FLOW: {
                this.block = (PcodeBlockBasic)highFunction.getBasicBlocks().get(row.getBlockIndex());
                this.pcodeOp = row.getPcodeOpAST();
                this.previousPcodeOp = row.getPreviousPcodeOpAST();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported feature type: " + row.getBSimFeatureType().toString());
            }
        }
    }

    public BsfvTokenHighlightMatcher(PcodeOpAST pcodeOp) {
        this.pcodeOp = pcodeOp;
    }

    public BsfvTokenHighlightMatcher(PcodeBlockBasic block) {
        this.block = block;
    }

    public BsfvTokenHighlightMatcher(PcodeOpAST pcodeOp, PcodeBlockBasic block) {
        this.pcodeOp = pcodeOp;
        this.block = block;
    }

    public BsfvTokenHighlightMatcher(PcodeOpAST pcodeOp, PcodeOpAST previousPcodeOp) {
        this.pcodeOp = pcodeOp;
        this.previousPcodeOp = previousPcodeOp;
    }

    public void start(ClangNode root) {
        ClangLine line;
        this.lineHighlights = new HashSet<Integer>();
        this.secondaryLineHighlights = new HashSet<Integer>();
        this.blockHighlights = new HashSet<Integer>();
        if (this.pcodeOp != null) {
            List opTokens = DecompilerUtils.getTokens((ClangNode)root, (Address)this.pcodeOp.getSeqnum().getTarget());
            for (ClangToken token : opTokens) {
                line = token.getLineParent();
                if (line == null) continue;
                this.lineHighlights.add(line.getLineNumber());
            }
        }
        if (this.previousPcodeOp != null) {
            List secondaryOpTokens = DecompilerUtils.getTokens((ClangNode)root, (Address)this.previousPcodeOp.getSeqnum().getTarget());
            for (ClangToken token : secondaryOpTokens) {
                line = token.getLineParent();
                if (line == null) continue;
                this.secondaryLineHighlights.add(line.getLineNumber());
            }
        }
        if (this.block != null) {
            AddressSet blockRange = new AddressSet(this.block.getStart(), this.block.getStop());
            List tokensInBlock = DecompilerUtils.getTokens((ClangNode)root, (AddressSetView)blockRange);
            for (ClangToken token : tokensInBlock) {
                ClangLine line2 = token.getLineParent();
                if (line2 == null) continue;
                this.blockHighlights.add(line2.getLineNumber());
            }
        }
    }

    public Color getTokenHighlight(ClangToken token) {
        ClangLine line;
        PcodeOp op;
        Options options = this.graphOptions.getOptions("Vertex Colors");
        String opKey = "Pcode Op";
        Color color = options.getColor(opKey, DEFAULT_HIGHLIGHT);
        if (token instanceof ClangFuncNameToken) {
            op = token.getPcodeOp();
            if (op == null) {
                return null;
            }
            if (this.pcodeOp != null && op.getSeqnum().equals((Object)this.pcodeOp.getSeqnum())) {
                return color;
            }
            if (this.previousPcodeOp != null && op.getSeqnum().equals((Object)this.previousPcodeOp.getSeqnum())) {
                return Gui.darker((Color)color);
            }
        }
        if (token instanceof ClangOpToken) {
            op = token.getPcodeOp();
            if (op == null) {
                return null;
            }
            if (this.pcodeOp != null && op.getSeqnum().equals((Object)this.pcodeOp.getSeqnum())) {
                return color;
            }
            if (this.previousPcodeOp != null && op.getSeqnum().equals((Object)this.previousPcodeOp.getSeqnum())) {
                return Gui.darker((Color)color);
            }
        }
        if (token instanceof ClangVariableToken) {
            ClangVariableToken varToken = (ClangVariableToken)token;
            PcodeOp op2 = varToken.getPcodeOp();
            Varnode vnode = varToken.getVarnode();
            if (op2 == null) {
                return null;
            }
            if (this.pcodeOp != null && op2.getSeqnum().equals((Object)this.pcodeOp.getSeqnum()) && vnode != null && vnode.equals((Object)op2.getOutput())) {
                return options.getColor("Base Varnode", DEFAULT_HIGHLIGHT);
            }
            if (this.previousPcodeOp != null && op2.getSeqnum().equals((Object)this.previousPcodeOp.getSeqnum()) && vnode != null && vnode.equals((Object)op2.getOutput())) {
                return options.getColor("Secondary Base Varnode", DEFAULT_HIGHLIGHT);
            }
        }
        if ((line = token.getLineParent()) != null) {
            if (this.lineHighlights.contains(line.getLineNumber())) {
                return LINE_HIGHLIGHT_COLOR;
            }
            if (this.secondaryLineHighlights.contains(line.getLineNumber())) {
                return SECONDARY_LINE_HIGHLIGHT_COLOR;
            }
            if (this.blockHighlights.contains(line.getLineNumber())) {
                return options.getColor("Base Block", DEFAULT_HIGHLIGHT);
            }
        }
        return null;
    }
}

