/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.PicProcessor;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;

public class PicSwitchAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "PIC Switch Tables";
    private static final String DESCRIPTION = "Analyzes PIC Switch instructions.";
    private static final int MAX_CASE_SIZE = 32;
    private static final HashSet<String> SKIP_INSTRUCTIONS = new HashSet();
    private Program program;
    private Listing listing;
    private ReferenceManager refMgr;
    private PseudoDisassembler pseudoDisassembler;
    private AddressSet disassemblyPoints;
    private AddressSet secondPassPoints;

    public PicSwitchAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.DISASSEMBLY.after().after().after().after());
    }

    private PicSwitchAnalyzer(Program program) {
        this();
        this.program = program;
        this.listing = program.getListing();
        this.refMgr = program.getReferenceManager();
        this.disassemblyPoints = new AddressSet();
        this.secondPassPoints = new AddressSet();
        this.pseudoDisassembler = new PseudoDisassembler(program);
    }

    public boolean canAnalyze(Program p) {
        Processor processor = p.getLanguage().getProcessor();
        return processor == PicProcessor.PROCESSOR_PIC_12 || processor == PicProcessor.PROCESSOR_PIC_16 || processor == PicProcessor.PROCESSOR_PIC_17 || processor == PicProcessor.PROCESSOR_PIC_18;
    }

    public boolean getDefaultEnablement(Program p) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean added(Program p, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.program = p;
        this.listing = this.program.getListing();
        this.refMgr = this.program.getReferenceManager();
        this.disassemblyPoints = new AddressSet();
        this.secondPassPoints = new AddressSet();
        try {
            this.pseudoDisassembler = new PseudoDisassembler(this.program);
            InstructionIterator instrIter = this.listing.getInstructions(set, true);
            while (instrIter.hasNext()) {
                Instruction instr = instrIter.next();
                if (!instr.getFlowType().isJump()) continue;
                if ("ADDWF".equals(instr.getMnemonicString())) {
                    this.handleAddSwitch(instr);
                    continue;
                }
                if (!"MOVWF".equals(instr.getMnemonicString())) continue;
                this.handleAddSwitch(instr);
            }
            this.performFollowOnAnalysis();
        }
        finally {
            this.program = null;
            this.listing = null;
            this.refMgr = null;
        }
        return true;
    }

    private boolean performFollowOnAnalysis() {
        AutoAnalysisManager mgr;
        boolean analysisRequired = false;
        if (!this.disassemblyPoints.isEmpty()) {
            analysisRequired = true;
            mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
            mgr.disassemble((AddressSetView)this.disassemblyPoints);
        }
        if (!this.secondPassPoints.isEmpty()) {
            analysisRequired = true;
            mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
            mgr.scheduleOneTimeAnalysis((Analyzer)this, (AddressSetView)this.secondPassPoints);
        }
        return analysisRequired;
    }

    public static boolean addSwitch(Instruction instr) {
        PicSwitchAnalyzer analyzer = new PicSwitchAnalyzer(instr.getProgram());
        analyzer.handleAddSwitch(instr);
        return analyzer.performFollowOnAnalysis();
    }

    private void handleAddSwitch(Instruction instr) {
        AddressSet caseRange = new AddressSet();
        int caseNum = 0;
        int caseSize = -1;
        Address instrAddr = instr.getMinAddress();
        boolean caseUpdate = false;
        Reference[] refs = this.program.getReferenceManager().getReferencesFrom(instr.getMinAddress(), -1);
        if (refs.length == 1) {
            return;
        }
        for (Reference ref : refs) {
            if (!ref.getReferenceType().isFlow()) continue;
            caseUpdate = true;
            break;
        }
        AddressSet casePoints = new AddressSet();
        Address caseAddr = instrAddr.add(2L);
        while (true) {
            int bytesConsumed;
            if (caseSize > 0) {
                caseAddr = caseAddr.add((long)caseSize);
            }
            if (caseUpdate) {
                if (this.refMgr.getReference(instr.getMinAddress(), caseAddr, -1) == null) {
                    if (this.listing.getUndefinedDataAt(caseAddr) == null || !this.testDisassmbleFinalCaseAt(caseAddr, caseSize, caseRange)) break;
                    this.refMgr.addMemoryReference(instr.getMinAddress(), caseAddr, (RefType)RefType.COMPUTED_JUMP, SourceType.ANALYSIS, -1);
                    this.disassemblyPoints.addRange(caseAddr, caseAddr);
                    break;
                }
            } else if (this.refMgr.hasReferencesTo(caseAddr)) break;
            if ((bytesConsumed = this.testDisassmbleCaseAt(caseAddr, caseSize)) == 0) {
                if (caseNum <= 1 || this.listing.getUndefinedDataAt(caseAddr) == null) break;
                this.secondPassPoints.addRange(instrAddr, instrAddr);
                break;
            }
            ++caseNum;
            caseSize = bytesConsumed;
            caseRange.addRange(caseAddr, caseAddr.add((long)(caseSize - 1)));
            if (caseUpdate) continue;
            casePoints.addRange(caseAddr, caseAddr);
        }
        if (casePoints.getNumAddresses() > 1L) {
            AddressIterator caseAddresses = casePoints.getAddresses(true);
            while (caseAddresses.hasNext()) {
                caseAddr = caseAddresses.next();
                this.refMgr.addMemoryReference(instr.getMinAddress(), caseAddr, (RefType)RefType.COMPUTED_JUMP, SourceType.ANALYSIS, -1);
                this.disassemblyPoints.addRange(caseAddr, caseAddr);
            }
        }
    }

    private int testDisassmbleCaseAt(Address caseAddr, int caseSize) {
        try {
            int byteCnt = 0;
            boolean skip = false;
            while (caseAddr != null) {
                PseudoInstruction instr = this.pseudoDisassembler.disassemble(caseAddr);
                if ((byteCnt += instr.getLength()) > 32 || caseSize > 0 && byteCnt > caseSize) {
                    return 0;
                }
                caseAddr = instr.getFallThrough();
                if (caseAddr == null && skip) {
                    caseAddr = instr.getMinAddress().add((long)instr.getLength());
                }
                skip = SKIP_INSTRUCTIONS.contains(instr.getMnemonicString());
            }
            if (caseSize <= 0 || byteCnt == caseSize) {
                return byteCnt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private boolean testDisassmbleFinalCaseAt(Address caseAddr, int caseSize, AddressSet caseRange) {
        try {
            int byteCnt = 0;
            boolean skip = false;
            while (caseAddr != null) {
                if (byteCnt != 0 && this.hasCaseRefTo(caseAddr, caseRange)) {
                    return true;
                }
                PseudoInstruction instr = this.pseudoDisassembler.disassemble(caseAddr);
                if ((byteCnt += instr.getLength()) <= 32 && (caseSize <= 0 || byteCnt <= caseSize)) {
                    caseAddr = instr.getFallThrough();
                    if (caseAddr == null && skip) {
                        caseAddr = instr.getMinAddress().add((long)instr.getLength());
                    }
                    skip = SKIP_INSTRUCTIONS.contains(instr.getMnemonicString());
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasCaseRefTo(Address addr, AddressSet caseRange) {
        ReferenceIterator refIter = this.refMgr.getReferencesTo(addr);
        while (refIter.hasNext()) {
            Reference ref = refIter.next();
            if (!caseRange.contains(ref.getFromAddress())) continue;
            return true;
        }
        return false;
    }

    static {
        SKIP_INSTRUCTIONS.add("CPFSEQ");
        SKIP_INSTRUCTIONS.add("CPFSGT");
        SKIP_INSTRUCTIONS.add("CPFSLT");
        SKIP_INSTRUCTIONS.add("DECFSZ");
        SKIP_INSTRUCTIONS.add("DCFSNZ");
        SKIP_INSTRUCTIONS.add("INCFSZ");
        SKIP_INSTRUCTIONS.add("INFSNZ");
        SKIP_INSTRUCTIONS.add("TSTFSZ");
        SKIP_INSTRUCTIONS.add("BTFSC");
        SKIP_INSTRUCTIONS.add("BTFSS");
    }
}

