/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.model;

import ghidra.trace.model.Lifespan;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GSpanField
extends JPanel {
    private static final String NEG_INF = "-\u221e";
    private static final String POS_INF = "+\u221e";
    private final JLabel labelLower = new JLabel("[");
    private final JComboBox<String> fieldMin = new JComboBox();
    private final JComboBox<String> fieldMax = new JComboBox();
    private final JLabel labelUpper = new JLabel("]");
    private final DefaultComboBoxModel<String> modelMin = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> modelMax = new DefaultComboBoxModel();

    public GSpanField() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.labelLower);
        this.add(this.fieldMin);
        this.add(new JLabel("\u2025"));
        this.add(this.fieldMax);
        this.add(this.labelUpper);
        this.modelMin.addElement(NEG_INF);
        this.modelMax.addElement(POS_INF);
        this.fieldMin.setEditable(true);
        this.fieldMin.setModel(this.modelMin);
        this.fieldMax.setEditable(true);
        this.fieldMax.setModel(this.modelMax);
        this.fieldMin.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GSpanField.this.minFocusLost(e);
                GSpanField.this.checkDispatchFocus(e);
            }
        });
        this.fieldMax.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GSpanField.this.maxFocusLost(e);
                GSpanField.this.checkDispatchFocus(e);
            }
        });
    }

    protected void checkDispatchFocus(FocusEvent e) {
        Component opp = e.getOppositeComponent();
        if (opp == null || !SwingUtilities.isDescendingFrom(opp, this)) {
            this.dispatchEvent(e);
        }
    }

    protected long parseLong(String text, long defaultVal) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    protected void revalidateMin() {
        String value = (String)this.fieldMin.getSelectedItem();
        if (NEG_INF.equals(value)) {
            this.labelLower.setText("(");
        } else {
            this.fieldMin.setSelectedItem(Long.toString(this.parseLong(value, 0L)));
            this.labelLower.setText("[");
        }
    }

    protected void revalidateMax() {
        String value = (String)this.fieldMax.getSelectedItem();
        if (POS_INF.equals(value)) {
            this.labelUpper.setText(")");
        } else {
            this.fieldMax.setSelectedItem(Long.toString(this.parseLong(value, 0L)));
            this.labelUpper.setText("]");
        }
    }

    protected void adjustMaxToMin() {
        if (this.unbounded()) {
            return;
        }
        long min = this.parseLong((String)this.fieldMin.getSelectedItem(), 0L);
        long max = Math.max(min, this.parseLong((String)this.fieldMax.getSelectedItem(), min));
        this.fieldMax.setSelectedItem(Long.toString(max));
    }

    protected boolean unbounded() {
        return NEG_INF.equals(this.fieldMin.getSelectedItem()) || POS_INF.equals(this.fieldMax.getSelectedItem());
    }

    protected void adjustMinToMax() {
        if (this.unbounded()) {
            return;
        }
        long max = this.parseLong((String)this.fieldMax.getSelectedItem(), 0L);
        long min = Math.min(max, this.parseLong((String)this.fieldMin.getSelectedItem(), max));
        this.fieldMin.setSelectedItem(Long.toString(min));
    }

    protected void minFocusLost(FocusEvent e) {
        this.revalidateMin();
        this.adjustMaxToMin();
    }

    protected void maxFocusLost(FocusEvent e) {
        this.revalidateMax();
        this.adjustMinToMax();
    }

    public void setLifespan(Lifespan lifespan) {
        if (!lifespan.minIsFinite()) {
            this.fieldMin.setSelectedItem(NEG_INF);
        } else {
            this.fieldMin.setSelectedItem(Long.toString(lifespan.lmin()));
        }
        if (!lifespan.maxIsFinite()) {
            this.fieldMax.setSelectedItem(POS_INF);
        } else {
            this.fieldMax.setSelectedItem(Long.toString(lifespan.lmax()));
        }
    }

    public Lifespan getLifespan() {
        String minStr = (String)this.fieldMin.getSelectedItem();
        String maxStr = (String)this.fieldMax.getSelectedItem();
        long min = NEG_INF.equals(minStr) ? Lifespan.DOMAIN.lmin() : Long.parseLong(minStr);
        long max = POS_INF.equals(maxStr) ? Lifespan.DOMAIN.lmax() : Long.parseLong(maxStr);
        return Lifespan.span(min, max);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fieldMin.setEnabled(enabled);
        this.fieldMax.setEnabled(enabled);
    }
}

