/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.auxiliary;

import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.auxiliary.AuxPcodeEmulator;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TracePcodeExecutorState;
import ghidra.pcode.exec.trace.TracePcodeMachine;
import ghidra.pcode.exec.trace.auxiliary.AuxTraceEmulatorPartsFactory;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.trace.model.guest.TracePlatform;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AuxTracePcodeEmulator<U>
extends AuxPcodeEmulator<U>
implements TracePcodeMachine<Pair<byte[], U>> {
    protected final PcodeTraceAccess access;

    public AuxTracePcodeEmulator(PcodeTraceAccess access) {
        super(access.getLanguage());
        this.access = access;
    }

    public AuxTracePcodeEmulator(TracePlatform platform, long snap) {
        this(new DefaultPcodeTraceAccess(platform, snap));
    }

    protected abstract AuxTraceEmulatorPartsFactory<U> getPartsFactory();

    protected PcodeThread<Pair<byte[], U>> createThread(String name) {
        PcodeThread thread = super.createThread(name);
        this.access.getDataForLocalState(thread, 0).initializeThreadContext(thread);
        return thread;
    }

    @Override
    public TracePcodeExecutorState<Pair<byte[], U>> createSharedState() {
        return this.getPartsFactory().createTraceSharedState(this, new BytesTracePcodeExecutorStatePiece(this.access.getDataForSharedState()));
    }

    @Override
    public TracePcodeExecutorState<Pair<byte[], U>> createLocalState(PcodeThread<Pair<byte[], U>> thread) {
        return this.getPartsFactory().createTraceLocalState(this, thread, new BytesTracePcodeExecutorStatePiece(this.access.getDataForLocalState(thread, 0)));
    }
}

