/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftFunction;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftFunctionNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Object name = null;
        Demangled namespace = null;
        Demangled type = null;
        Demangled labelList = null;
        String callingConvention = "default";
        block9: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block9;
                }
                case InfixOperator: {
                    name = child.getText() + " infix";
                    continue block9;
                }
                case LocalDeclName: {
                    name = child.demangle(demangler).getName();
                    continue block9;
                }
                case Class: {
                    callingConvention = "__thiscall";
                }
                case Enum: 
                case Extension: 
                case Function: 
                case Module: 
                case Protocol: 
                case Structure: {
                    namespace = child.demangle(demangler);
                    continue block9;
                }
                case Type: {
                    type = child.demangle(demangler);
                    continue block9;
                }
                case LabelList: {
                    labelList = child.demangle(demangler);
                    continue block9;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        SwiftFunction function = new SwiftFunction(this.properties.mangled(), this.properties.originalDemangled(), (String)name, namespace, callingConvention);
        if (type instanceof DemangledFunction) {
            DemangledFunction functionType = (DemangledFunction)type;
            function.setType(functionType, labelList);
        }
        return function;
    }
}

