/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.rzo.netty.ahessian.rpc.message.GroupedMessage;
import org.rzo.netty.ahessian.stopable.StopableHandler;
import org.rzo.netty.ahessian.utils.MyReentrantLock;
import org.rzo.netty.ahessian.utils.TimedBlockingPriorityQueue;

public abstract class OutputProducer
extends ChannelOutboundHandlerAdapter
implements StopableHandler,
ChannelInboundHandler {
    private TimedBlockingPriorityQueue<MessageEvent> _pendingCalls = new TimedBlockingPriorityQueue("OutputProducer");
    AtomicInteger _producerThreadsCount = new AtomicInteger(0);
    Lock _lock = new MyReentrantLock();
    Executor _executor;
    Timer _timer;
    List<MessageEvent> _pendingTermination = new ArrayList<MessageEvent>();
    ChannelHandlerContext _ctx;
    volatile boolean _stop = false;

    public OutputProducer(Executor executor) {
        this._executor = executor;
    }

    public void write(final ChannelHandlerContext ctx, Object e, ChannelPromise promise) throws Exception {
        if (e instanceof GroupedMessage) {
            GroupedMessage m = (GroupedMessage)e;
            this._pendingCalls.put(new MessageEvent(e, promise), m.getGroup());
        } else {
            this._pendingCalls.put(new MessageEvent(e, promise));
        }
        if (this._producerThreadsCount.get() < 2) {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    OutputProducer.this.produce(ctx);
                }
            });
        }
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.doChannelActive(ctx);
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.doChannelActive(ctx);
        ctx.fireChannelActive();
    }

    private void doChannelActive(final ChannelHandlerContext ctx) {
        this._ctx = ctx;
        this._executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Iterator<MessageEvent> it = OutputProducer.this._pendingTermination.iterator();
                while (it.hasNext()) {
                    OutputProducer.this._lock.lock();
                    try {
                        if (OutputProducer.this._stop) {
                            return;
                        }
                        MessageEvent e = it.next();
                        if (e.getMsg() instanceof GroupedMessage) {
                            GroupedMessage m = (GroupedMessage)e.getMsg();
                            OutputProducer.this._pendingCalls.put(e, m.getGroup());
                            continue;
                        }
                        OutputProducer.this._pendingCalls.put(e);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        OutputProducer.this._lock.unlock();
                    }
                }
                OutputProducer.this.produce(ctx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produce(ChannelHandlerContext ctx) {
        if (this._stop) {
            return;
        }
        if (this._producerThreadsCount.incrementAndGet() > 2) {
            this._producerThreadsCount.decrementAndGet();
            return;
        }
        boolean produced = false;
        this._lock.lock();
        try {
            MessageEvent toSend = null;
            while (ctx.channel().isActive() && this._pendingCalls.size() > 0) {
                if (this._stop) {
                    return;
                }
                try {
                    toSend = this._pendingCalls.take();
                    this.produceOutput(ctx, toSend.getMsg(), toSend.getFuture());
                    this._pendingTermination.add(toSend);
                    produced = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this._pendingCalls.put(toSend, ((GroupedMessage)toSend.getMsg()).getGroup());
                }
            }
            if (produced && this._pendingCalls.size() == 0) {
                this.flashOutput(ctx);
                Iterator<MessageEvent> it = this._pendingTermination.iterator();
                while (it.hasNext()) {
                    if (this._stop) {
                        return;
                    }
                    try {
                        MessageEvent e = it.next();
                        it.remove();
                        e.getFuture().setSuccess();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this._producerThreadsCount.decrementAndGet();
            this._lock.unlock();
        }
    }

    protected abstract void flashOutput(ChannelHandlerContext var1) throws Exception;

    protected abstract void produceOutput(ChannelHandlerContext var1, Object var2, ChannelPromise var3) throws Exception;

    @Override
    public boolean isStopEnabled() {
        return true;
    }

    @Override
    public void setStopEnabled(boolean stopEnabled) {
    }

    @Override
    public void stop() {
        this._stop = true;
        for (MessageEvent event : this._pendingCalls) {
            event.getFuture().cancel(true);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelUnregistered();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelWritabilityChanged();
    }

    class MessageEvent {
        Object _msg;
        ChannelPromise _future;

        public MessageEvent(Object msg, ChannelPromise future) {
            this._msg = msg;
            this._future = future;
        }

        public Object getMsg() {
            return this._msg;
        }

        public ChannelPromise getFuture() {
            return this._future;
        }
    }
}

