/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.util.job;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.util.Caching;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.graph.job.AbstractAnimatorJob;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.collections4.IterableUtils;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class MergeVertexFunctionGraphJob
extends AbstractAnimatorJob {
    private static final int DURATION = 1500;
    private final VisualizationServer<FGVertex, FGEdge> viewer;
    private Layout<FGVertex, FGEdge> graphLayout;
    private final FGVertex mergedVertex;
    private final FGVertex parentVertex;
    private final FGVertex childVertex;
    private Point2D parentStart;
    private Point2D childStart;
    private Point2D parentDestination;
    private Point2D childDestination;
    private Point2D mergedDestination;
    private final boolean useAnimation;
    private final FGController controller;

    public MergeVertexFunctionGraphJob(FGController controller, VisualizationServer<FGVertex, FGEdge> viewer, FGVertex mergedVertex, FGVertex newParentVertex, FGVertex newChildVertex, boolean useAnimation) {
        this.controller = controller;
        this.viewer = viewer;
        this.mergedVertex = mergedVertex;
        this.parentVertex = newParentVertex;
        this.childVertex = newChildVertex;
        this.useAnimation = useAnimation;
        this.graphLayout = viewer.getGraphLayout();
        this.updateOpacity(0.0);
    }

    public boolean canShortcut() {
        return false;
    }

    public void shortcut() {
        throw new UnsupportedOperationException("Cannot cancel this job: " + String.valueOf((Object)this));
    }

    protected Animator createAnimator() {
        this.initializeVertexLocations();
        if (!this.useAnimation) {
            return null;
        }
        Animator newAnimator = PropertySetter.createAnimator((int)1500, (Object)((Object)this), (String)"percentComplete", (Object[])new Double[]{0.0, 1.0});
        newAnimator.setAcceleration(0.0f);
        newAnimator.setDeceleration(0.8f);
        return newAnimator;
    }

    protected void finished() {
        if (this.isShortcut) {
            this.initializeVertexLocations();
        }
        this.clearLocationCache();
        this.graphLayout.setLocation((Object)this.mergedVertex, this.mergedDestination);
        this.removeOldVertexAndEdges();
        this.updateOpacity(1.0);
        this.controller.synchronizeProgramLocationAfterEdit();
        this.viewer.repaint();
    }

    public void setPercentComplete(double percentComplete) {
        this.updateNewVertexPositions(percentComplete);
        this.updateOpacity(percentComplete);
        this.viewer.repaint();
    }

    protected void clearLocationCache() {
        Layout jungLayout = this.viewer.getGraphLayout();
        ((Caching)jungLayout).clear();
    }

    private void initializeVertexLocations() {
        Rectangle originalBounds = this.parentVertex.getBounds();
        Rectangle newBounds = this.mergedVertex.getBounds();
        int dy = newBounds.height - originalBounds.height >> 1;
        Point2D parentLocation = (Point2D)this.graphLayout.apply((Object)this.parentVertex);
        Point2D mergedLocation = (Point2D)parentLocation.clone();
        mergedLocation.setLocation(parentLocation.getX(), parentLocation.getY() + (double)dy);
        this.parentDestination = this.parentStart = parentLocation;
        this.childStart = (Point2D)this.graphLayout.apply((Object)this.childVertex);
        this.childDestination = this.parentDestination;
        this.mergedDestination = mergedLocation;
        Point2D oldLocationProperty = this.parentVertex.getLocation();
        this.mergedVertex.setLocation(oldLocationProperty);
        this.graphLayout.setLocation((Object)this.mergedVertex, this.mergedDestination);
        this.clearLocationCache();
    }

    private void updateNewVertexPositions(double percentComplete) {
        double parentDestinationX = this.parentDestination.getX();
        double parentDeltaX = (parentDestinationX - this.parentStart.getX()) * percentComplete;
        double childDestinationY = this.childDestination.getY();
        double childDeltaY = (childDestinationY - this.childStart.getY()) * percentComplete;
        double childDestinationX = this.childDestination.getX();
        double childDeltaX = (childDestinationX - this.childStart.getX()) * percentComplete;
        double parentDestinationY = this.parentDestination.getY();
        double parentDeltaY = (parentDestinationY - this.parentStart.getY()) * percentComplete;
        double newParentX = this.parentStart.getX() + parentDeltaX;
        double newParentY = this.parentStart.getY() + parentDeltaY;
        double newChildX = this.childStart.getX() + childDeltaX;
        double newChildY = this.childStart.getY() + childDeltaY;
        Point2D.Double newParentLocation = new Point2D.Double(newParentX, newParentY);
        Point2D.Double newChildLocation = new Point2D.Double(newChildX, newChildY);
        this.parentVertex.setLocation(newParentLocation);
        this.childVertex.setLocation(newChildLocation);
        this.clearLocationCache();
        this.graphLayout.setLocation((Object)this.parentVertex, (Point2D)newParentLocation);
        this.graphLayout.setLocation((Object)this.childVertex, (Point2D)newChildLocation);
    }

    private void updateOpacity(double percentComplete) {
        double oldComponentsAlpha = 1.0 - percentComplete;
        this.parentVertex.setAlpha(oldComponentsAlpha);
        this.childVertex.setAlpha(oldComponentsAlpha);
        Collection<FGEdge> edges = IterableUtils.chainedIterable(this.getEdges(this.parentVertex), this.getEdges(this.childVertex));
        for (FGEdge edge : edges) {
            double defaultAlpha = edge.getDefaultAlpha();
            double alpha = Math.min(oldComponentsAlpha, defaultAlpha);
            edge.setAlpha(alpha);
        }
        double newComponentsAlpha = percentComplete;
        this.mergedVertex.setAlpha(newComponentsAlpha);
        edges = this.getEdges(this.mergedVertex);
        for (FGEdge edge : edges) {
            double defaultAlpha = edge.getDefaultAlpha();
            double alpha = Math.min(newComponentsAlpha, defaultAlpha);
            edge.setAlpha(alpha);
        }
    }

    private Collection<FGEdge> getEdges(FGVertex vertex) {
        Collection outEdges;
        Graph graph = this.graphLayout.getGraph();
        LinkedList<FGEdge> edges = new LinkedList<FGEdge>();
        Collection inEdges = graph.getInEdges((Object)vertex);
        if (inEdges != null) {
            edges.addAll(inEdges);
        }
        if ((outEdges = graph.getOutEdges((Object)vertex)) != null) {
            edges.addAll(outEdges);
        }
        return edges;
    }

    private void removeOldVertexAndEdges() {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph graph = functionGraphData.getFunctionGraph();
        graph.removeVertex(this.parentVertex);
        graph.removeVertex(this.childVertex);
    }
}

