/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import org.jdom.Element;

public class ColumnSortState {
    static final String XML_COLUMN_SORT_STATE = "COLUMN_SORT_STATE";
    private static final String XML_COLUMN_MODEL_INDEX = "COLUMN_MODEL_INDEX";
    private static final String XML_SORT_DIRECTION = "SORT_DIRECTION";
    private static final String XML_SORT_ORDER = "SORT_ORDER";
    private int columnModelIndex;
    private SortDirection sortDirection;
    private int sortOrder_OneBased = -1;

    ColumnSortState(int columnModelIndex, SortDirection sortDirection, int sortOrder) {
        if (columnModelIndex < 0) {
            throw new IllegalArgumentException("Column index cannot be negative");
        }
        this.columnModelIndex = columnModelIndex;
        this.sortDirection = sortDirection;
        this.sortOrder_OneBased = sortOrder;
    }

    void setSortOrder(int sortOrder) {
        this.sortOrder_OneBased = sortOrder;
    }

    public int getSortOrder() {
        return this.sortOrder_OneBased;
    }

    public int getColumnModelIndex() {
        return this.columnModelIndex;
    }

    public boolean isAscending() {
        return this.sortDirection.isAscending();
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public ColumnSortState createFlipState() {
        ColumnSortState newSortState = new ColumnSortState(this.columnModelIndex, this.isAscending() ? SortDirection.DESCENDING : SortDirection.ASCENDING, this.sortOrder_OneBased);
        return newSortState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnModelIndex;
        result = 31 * result + (this.sortDirection == null ? 0 : this.sortDirection.hashCode());
        result = 31 * result + this.sortOrder_OneBased;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnSortState other = (ColumnSortState)obj;
        if (this.columnModelIndex != other.columnModelIndex) {
            return false;
        }
        if (this.sortDirection == null ? other.sortDirection != null : !this.sortDirection.equals((Object)other.sortDirection)) {
            return false;
        }
        return this.sortOrder_OneBased == other.sortOrder_OneBased;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[column:" + this.columnModelIndex + ",direction:" + String.valueOf((Object)this.sortDirection) + ",order:" + this.sortOrder_OneBased + "]";
    }

    public static ColumnSortState restoreFromXML(Element element) {
        String modelIndexValue = element.getAttributeValue(XML_COLUMN_MODEL_INDEX);
        int modelIndex = Integer.parseInt(modelIndexValue);
        String sortOrderValue = element.getAttributeValue(XML_SORT_ORDER);
        int sortOrder = Integer.parseInt(sortOrderValue);
        String sortDirectionValue = element.getAttributeValue(XML_SORT_DIRECTION);
        SortDirection sortDirection = SortDirection.getSortDirection(sortDirectionValue);
        return new ColumnSortState(modelIndex, sortDirection, sortOrder);
    }

    Element writeToXML() {
        Element sortStateElement = new Element(XML_COLUMN_SORT_STATE);
        sortStateElement.setAttribute(XML_COLUMN_MODEL_INDEX, Integer.toString(this.columnModelIndex));
        sortStateElement.setAttribute(XML_SORT_DIRECTION, this.sortDirection.toString());
        sortStateElement.setAttribute(XML_SORT_ORDER, Integer.toString(this.sortOrder_OneBased));
        return sortStateElement;
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING,
        UNSORTED;


        public boolean isAscending() {
            return this == ASCENDING;
        }

        public String toString() {
            if (this.isAscending()) {
                return "ascending";
            }
            return "descending";
        }

        public static SortDirection getSortDirection(String direction) {
            if (direction.equals("ascending")) {
                return ASCENDING;
            }
            return DESCENDING;
        }
    }
}

