/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.ConfigurableColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.TableColumnModelState;
import ghidra.docking.settings.Settings;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdom.Element;

public class GTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener {
    private VisibleColumns visibleColumns = new VisibleColumns(this);
    private List<TableColumn> completeList = new ArrayList<TableColumn>();
    private int totalColumnWidth;
    private int columnMargin;
    private boolean columnSelectionAllowed;
    private ChangeEvent columnMarginChangeEvent = new ChangeEvent(this);
    private WeakSet<TableColumnModelListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private GTable table;
    protected ListSelectionModel selectionModel;
    private TableColumnModelState columnModelState;

    GTableColumnModel(GTable table) {
        this.table = table;
        this.setSelectionModel(new DefaultListSelectionModel());
        this.setColumnMargin(1);
        this.invalidateWidthCache();
        this.setColumnSelectionAllowed(false);
        this.columnModelState = this.createTableColumnModelState();
    }

    protected TableColumnModelState createTableColumnModelState() {
        return new TableColumnModelState(this.table, this);
    }

    protected GTable getGTable() {
        return this.table;
    }

    void removeAllColumns() {
        this.fireColumnRemoved(new TableColumnModelEvent(this, 0, this.visibleColumns.size() - 1));
        this.visibleColumns.clear();
        this.completeList.clear();
        this.invalidateWidthCache();
        this.columnModelState.saveState();
    }

    void dispose() {
        this.listeners.clear();
        this.visibleColumns.clear();
        this.completeList.clear();
        this.columnModelState.dispose();
    }

    public boolean isVisible(TableColumn column) {
        return this.visibleColumns.contains(column);
    }

    public boolean isVisible(int modelIndex) {
        TableColumn tableColumn = this.getColumnFromModelIndex(modelIndex);
        return this.isVisible(tableColumn);
    }

    public void setVisible(TableColumn column, boolean visible) {
        boolean isVisible = this.visibleColumns.contains(column);
        if (visible == isVisible) {
            return;
        }
        if (visible) {
            int insertIndex = this.findVisibleInsertionIndex(column);
            this.visibleColumns.add(insertIndex, column);
            this.fireColumnAdded(new TableColumnModelEvent(this, insertIndex, insertIndex));
        } else {
            int columnIndex = this.visibleColumns.indexOf(column);
            this.visibleColumns.remove(columnIndex);
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(columnIndex, columnIndex);
            }
            this.fireColumnRemoved(new TableColumnModelEvent(this, columnIndex, columnIndex));
        }
        this.invalidateWidthCache();
        this.columnModelState.saveState();
    }

    private int findVisibleInsertionIndex(TableColumn column) {
        int completeIndex = this.completeList.indexOf(column);
        int size = this.visibleColumns.size();
        for (int i = completeIndex + 1; i < size; ++i) {
            TableColumn nextColumn = this.completeList.get(i);
            int visibleIndex = this.visibleColumns.indexOf(nextColumn);
            if (visibleIndex == -1) continue;
            return visibleIndex;
        }
        return size;
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        Objects.requireNonNull(aColumn);
        this.removeColumnWithModelIndex(aColumn.getModelIndex());
        this.completeList.add(aColumn);
        this.visibleColumns.add(aColumn);
        aColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
        this.columnModelState.restoreState();
    }

    public void addHiddenColumn(TableColumn aColumn) {
        Objects.requireNonNull(aColumn);
        this.removeColumnWithModelIndex(aColumn.getModelIndex());
        this.completeList.add(aColumn);
        aColumn.addPropertyChangeListener(this);
    }

    private TableColumn getColumnFromModelIndex(int modelIndex) {
        for (TableColumn tableColumn : this.completeList) {
            if (tableColumn.getModelIndex() != modelIndex) continue;
            return tableColumn;
        }
        return null;
    }

    private void removeColumnWithModelIndex(int modelIndex) {
        TableColumn tableColumn = this.getColumnFromModelIndex(modelIndex);
        if (tableColumn == null) {
            return;
        }
        this.completeList.remove(tableColumn);
        this.visibleColumns.remove(tableColumn);
        tableColumn.removePropertyChangeListener(this);
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public TableColumn getColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.visibleColumns.size()) {
            return null;
        }
        return this.visibleColumns.get(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    @Override
    public int getColumnIndex(Object columnIdentifier) {
        if (columnIdentifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        for (int i = 0; i < this.visibleColumns.size(); ++i) {
            TableColumn tableColumn = this.visibleColumns.get(i);
            if (!columnIdentifier.equals(tableColumn.getIdentifier())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnIndexAtX(int x) {
        if (x < 0) {
            return -1;
        }
        int cc = this.getColumnCount();
        int columnIndex = x;
        for (int i = 0; i < cc; ++i) {
            TableColumn column = this.getColumn(i);
            if ((columnIndex -= column.getWidth()) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.visibleColumns.toEnumeration();
    }

    public List<TableColumn> getAllColumns() {
        return new ArrayList<TableColumn>(this.completeList);
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            int count = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0];
            }
            int[] tmp = new int[1 + (iMax - iMin)];
            int n = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                tmp[n++] = i;
            }
            int[] selectedColumns = new int[n];
            System.arraycopy(tmp, 0, selectedColumns, 0, n);
            return selectedColumns;
        }
        return new int[0];
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (columnIndex == newIndex) {
            this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
            return;
        }
        TableColumn movedColumn = this.visibleColumns.remove(columnIndex);
        this.visibleColumns.add(newIndex, movedColumn);
        this.completeList.remove(movedColumn);
        if (columnIndex > newIndex) {
            column = this.visibleColumns.get(newIndex + 1);
            int index = this.completeList.indexOf(column);
            this.completeList.add(index, movedColumn);
        } else {
            column = this.visibleColumns.get(newIndex - 1);
            int index = this.completeList.indexOf(column);
            this.completeList.add(index + 1, movedColumn);
        }
        boolean selected = this.selectionModel.isSelectedIndex(columnIndex);
        this.selectionModel.removeIndexInterval(columnIndex, columnIndex);
        this.selectionModel.insertIndexInterval(newIndex, 1, true);
        if (selected) {
            this.selectionModel.addSelectionInterval(newIndex, newIndex);
        } else {
            this.selectionModel.removeSelectionInterval(newIndex, newIndex);
        }
        this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
        this.columnModelState.saveState();
    }

    @Override
    public void removeColumn(TableColumn column) {
        this.completeList.remove(column);
        int index = this.visibleColumns.indexOf(column);
        if (index >= 0) {
            this.visibleColumns.remove(index);
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(index, index);
            }
            this.fireColumnRemoved(new TableColumnModelEvent(this, index, index));
        }
        this.invalidateWidthCache();
        this.columnModelState.saveState();
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void setColumnMargin(int newMargin) {
        if (newMargin != this.columnMargin) {
            this.columnMargin = newMargin;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public void setColumnSelectionAllowed(boolean flag) {
        this.columnSelectionAllowed = flag;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel oldModel = this.selectionModel;
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeListSelectionListener(this);
            }
            this.selectionModel = newModel;
            newModel.addListSelectionListener(this);
        }
    }

    private void recalcWidthCache() {
        this.totalColumnWidth = 0;
        for (TableColumn tableColumn : this.visibleColumns.getColumns()) {
            this.totalColumnWidth += tableColumn.getWidth();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    void restoreState(List<TableColumn> newCompleteList, List<Settings> newSettingsList, List<TableColumn> newVisibleList) {
        this.completeList = newCompleteList;
        this.visibleColumns = new VisibleColumns(this, newVisibleList);
        TableModel model = this.table.getModel();
        if (model instanceof ConfigurableColumnTableModel) {
            ConfigurableColumnTableModel configurableModel = (ConfigurableColumnTableModel)model;
            Settings[] columnIndexAndSettings = new Settings[newCompleteList.size()];
            for (int i = 0; i < columnIndexAndSettings.length; ++i) {
                int modelIndex = newCompleteList.get(i).getModelIndex();
                columnIndexAndSettings[modelIndex] = newSettingsList.get(modelIndex);
            }
            configurableModel.setAllColumnSettings(columnIndexAndSettings);
        }
        TableColumnModelEvent e = new TableColumnModelEvent(this, 0, this.getColumnCount() - 1);
        this.fireColumnAdded(e);
    }

    void saveState() {
        this.columnModelState.saveState();
    }

    void forceSaveState() {
        this.columnModelState.forceSaveState();
    }

    void restoreState() {
        this.columnModelState.restoreState();
    }

    boolean setEventsEnabled(boolean enabled) {
        boolean oldValue = this.columnModelState.isEnabled();
        if (oldValue == enabled) {
            return oldValue;
        }
        this.columnModelState.setEnabled(enabled);
        if (enabled) {
            this.columnModelState.restoreStateNow();
        }
        return oldValue;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("width".equals(name) || "preferredWidth".equals(name)) {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
            this.columnModelState.saveState();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }

    private void fireColumnAdded(TableColumnModelEvent e) {
        for (TableColumnModelListener listener : this.listeners) {
            listener.columnAdded(e);
        }
    }

    private void fireColumnRemoved(TableColumnModelEvent e) {
        for (TableColumnModelListener listener : this.listeners) {
            listener.columnRemoved(e);
        }
    }

    private void fireColumnSelectionChanged(ListSelectionEvent e) {
        for (TableColumnModelListener listener : this.listeners) {
            listener.columnSelectionChanged(e);
        }
    }

    private void fireColumnMoved(TableColumnModelEvent event) {
        for (TableColumnModelListener listener : this.listeners) {
            listener.columnMoved(event);
        }
    }

    private void fireColumnMarginChanged() {
        for (TableColumnModelListener listener : this.listeners) {
            listener.columnMarginChanged(this.columnMarginChangeEvent);
        }
    }

    public Element saveToXML() {
        return this.columnModelState.saveToXML();
    }

    public void restoreFromXML(Element element) {
        this.columnModelState.restoreFromXML(element);
    }

    private class VisibleColumns {
        private Set<TableColumn> visibleSet = new HashSet<TableColumn>();
        private List<TableColumn> visibleList = new ArrayList<TableColumn>();

        public VisibleColumns(GTableColumnModel gTableColumnModel) {
        }

        public VisibleColumns(GTableColumnModel gTableColumnModel, List<TableColumn> newVisibleList) {
            this.visibleList = newVisibleList;
            this.visibleSet.addAll(this.visibleList);
        }

        List<TableColumn> getColumns() {
            return this.visibleList;
        }

        int size() {
            return this.visibleList.size();
        }

        public void remove(TableColumn column) {
            this.visibleList.remove(column);
            this.visibleSet.remove(column);
        }

        public void add(TableColumn column) {
            this.visibleList.add(column);
            this.visibleSet.add(column);
        }

        public Enumeration<TableColumn> toEnumeration() {
            return Collections.enumeration(this.visibleList);
        }

        public TableColumn get(int index) {
            return this.visibleList.get(index);
        }

        public int indexOf(TableColumn column) {
            return this.visibleList.indexOf(column);
        }

        public TableColumn remove(int index) {
            TableColumn column = this.visibleList.remove(index);
            this.visibleSet.remove(column);
            return column;
        }

        public void add(int insertIndex, TableColumn column) {
            this.visibleList.add(insertIndex, column);
            this.visibleSet.add(column);
        }

        void clear() {
            this.visibleList.clear();
            this.visibleSet.clear();
        }

        boolean contains(TableColumn c) {
            return this.visibleSet.contains(c);
        }
    }
}

