/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.ColumnSortState;
import docking.widgets.table.TableSortState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TableSortStateEditor {
    private List<ColumnSortState> sortStates = new ArrayList<ColumnSortState>();

    public TableSortStateEditor() {
    }

    public TableSortStateEditor(TableSortState tableSortState) {
        for (ColumnSortState sortState : tableSortState) {
            this.sortStates.add(sortState);
        }
    }

    public void addSortedColumn(ColumnSortState sortState) {
        this.validateColumns(sortState.getColumnModelIndex());
        this.sortStates.add(sortState);
    }

    public void addSortedColumn(int columnIndex) {
        this.addSortedColumn(columnIndex, ColumnSortState.SortDirection.ASCENDING);
    }

    public void addSortedColumn(int columnIndex, ColumnSortState.SortDirection direction) {
        this.addSortedColumn(new ColumnSortState(columnIndex, direction, this.getNextColumnSortOrder()));
    }

    public ColumnSortState getColumnSortState(int sortStateIndex) {
        return this.sortStates.get(sortStateIndex);
    }

    private int getNextColumnSortOrder() {
        return this.getSortedColumnCount() + 1;
    }

    public void removeSortedColumn(int columnIndex) {
        int existingIndex = this.indexOf(columnIndex);
        if (existingIndex < 0) {
            throw new IllegalArgumentException("Attempted to remove a column that is not sorted.");
        }
        this.sortStates.remove(existingIndex);
        this.recalculateSortOrder();
    }

    private void recalculateSortOrder() {
        for (int i = 0; i < this.sortStates.size(); ++i) {
            this.sortStates.get(i).setSortOrder(i + 1);
        }
    }

    public void flipColumnSortDirection(int columnIndex) {
        int existingIndex = this.indexOf(columnIndex);
        if (existingIndex < 0) {
            throw new IllegalArgumentException("Cannot change sort direction when column is not sorted");
        }
        ColumnSortState sortState = this.sortStates.get(existingIndex);
        this.sortStates.set(existingIndex, sortState.createFlipState());
    }

    private void validateColumns(int columnIndex) {
        int existingIndex = this.indexOf(columnIndex);
        if (existingIndex >= 0) {
            throw new IllegalStateException("Cannot add a sort state when one is already set at column: " + columnIndex);
        }
    }

    private int indexOf(int columnIndex) {
        for (int i = 0; i < this.sortStates.size(); ++i) {
            ColumnSortState sortState = this.sortStates.get(i);
            if (sortState.getColumnModelIndex() != columnIndex) continue;
            return i;
        }
        return -1;
    }

    public Iterator<ColumnSortState> iterator() {
        return Collections.unmodifiableList(this.sortStates).iterator();
    }

    public TableSortState createTableSortState() {
        return new TableSortState(this.sortStates);
    }

    public void clear() {
        this.sortStates.clear();
    }

    public boolean isColumnSorted(int columnIndex) {
        return this.indexOf(columnIndex) != -1;
    }

    public int getSortedColumnCount() {
        return this.sortStates.size();
    }
}

