/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MethodParameters
implements StructConverter {
    private static final int ACC_FINAL_INDEX = 16;
    private static final int ACC_SYNTHETIC_INDEX = 4096;
    private static final int ACC_MANDATED_INDEX = 32768;
    private int name_index;
    private int access_flags;

    public MethodParameters(BinaryReader reader) throws IOException {
        this.name_index = Short.toUnsignedInt(reader.readNextShort());
        this.access_flags = Short.toUnsignedInt(reader.readNextShort());
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int getAcccessFlags() {
        return this.access_flags;
    }

    public boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public boolean isSynthetic() {
        return (this.access_flags & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.access_flags & 0x8000) != 0;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("method_parameters", 0);
        structure.add(WORD, "name_index", null);
        structure.add(WORD, "access_flags", null);
        return structure;
    }
}

