/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import docking.DialogComponentProvider;
import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.debug.api.ValStr;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;

public abstract class AbstractDebuggerParameterDialog<P>
extends DialogComponentProvider
implements PropertyChangeListener {
    static final String KEY_MEMORIZED_ARGUMENTS = "memorizedArguments";
    private final BidiMap<P, PropertyEditor> paramEditors = new DualLinkedHashBidiMap();
    private JPanel panel;
    private JLabel descriptionLabel;
    private JPanel pairPanel;
    private PairLayout layout;
    protected JButton invokeButton;
    protected JButton resetButton;
    private final PluginTool tool;
    Map<String, P> parameters;
    private Map<String, ValStr<?>> defaults = Map.of();
    private Map<NameTypePair, ValStr<?>> memorized = new HashMap();
    private Map<String, ValStr<?>> arguments;

    public AbstractDebuggerParameterDialog(PluginTool tool, String title, String buttonText, Icon buttonIcon) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.populateComponents(buttonText, buttonIcon);
        this.setRememberSize(false);
    }

    protected abstract String parameterName(P var1);

    protected abstract Class<?> parameterType(P var1);

    protected NameTypePair parameterNameAndType(P parameter) {
        return new NameTypePair(this.parameterName(parameter), this.parameterType(parameter));
    }

    protected abstract String parameterLabel(P var1);

    protected abstract String parameterToolTip(P var1);

    protected abstract ValStr<?> parameterDefault(P var1);

    protected abstract Collection<?> parameterChoices(P var1);

    protected abstract Map<String, ValStr<?>> validateArguments(Map<String, P> var1, Map<String, ValStr<?>> var2);

    protected abstract void parameterSaveValue(P var1, SaveState var2, String var3, ValStr<?> var4);

    protected abstract ValStr<?> parameterLoadValue(P var1, SaveState var2, String var3);

    protected ValStr<?> computeInitialValue(P parameter) {
        ValStr val = this.memorized.computeIfAbsent(this.parameterNameAndType(parameter), ntp -> this.defaults.get(this.parameterName(parameter)));
        return val;
    }

    public Map<String, ValStr<?>> promptArguments(Map<String, P> parameterMap, Map<String, ValStr<?>> initial, Map<String, ValStr<?>> defaults) {
        this.setDefaults(defaults);
        this.setParameters(parameterMap);
        this.setMemorizedArguments(initial);
        this.populateValues(initial);
        this.tool.showDialog((DialogComponentProvider)this);
        return this.getArguments();
    }

    protected void setParameters(Map<String, P> parameterMap) {
        this.parameters = parameterMap;
        for (P param : parameterMap.values()) {
            if (this.defaults.containsKey(this.parameterName(param))) continue;
            this.defaults.put(this.parameterName(param), this.parameterDefault(param));
        }
        this.populateOptions();
    }

    protected void setMemorizedArguments(Map<String, ValStr<?>> initial) {
        for (P param : this.parameters.values()) {
            ValStr<?> val = initial.get(this.parameterName(param));
            if (val == null) continue;
            this.setMemorizedArgument(param, val);
        }
    }

    protected void setDefaults(Map<String, ValStr<?>> defaults) {
        this.defaults = new HashMap(defaults);
    }

    private void populateComponents(String buttonText, Icon buttonIcon) {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layout = new PairLayout(5, 5);
        this.pairPanel = new JPanel((LayoutManager)this.layout);
        JPanel centering = new JPanel(new FlowLayout(1));
        JScrollPane scrolling = new JScrollPane(centering, 20, 31);
        this.panel.add((Component)scrolling, "Center");
        centering.add(this.pairPanel);
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setMaximumSize(new Dimension(300, 100));
        this.panel.add((Component)this.descriptionLabel, "North");
        this.addWorkPanel(this.panel);
        this.invokeButton = new JButton(buttonText, buttonIcon);
        this.addButton(this.invokeButton);
        this.resetButton = new JButton("Reset", DebuggerResources.ICON_REFRESH);
        this.addButton(this.resetButton);
        this.addCancelButton();
        this.invokeButton.addActionListener(this::invoke);
        this.resetButton.addActionListener(this::reset);
    }

    protected void cancelCallback() {
        this.arguments = null;
        this.close();
    }

    void invoke(ActionEvent evt) {
        try {
            this.arguments = this.validateArguments(this.parameters, this.collectArguments());
            this.close();
        }
        catch (IllegalStateException e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR, true);
        }
    }

    void reset(ActionEvent evt) {
        this.arguments = null;
        this.populateValues(this.defaults);
    }

    protected PropertyEditor createEditor(P parameter) {
        Collection<?> choices = this.parameterChoices(parameter);
        if (!choices.isEmpty()) {
            return new ChoicesPropertyEditor(choices);
        }
        Class<?> type = this.parameterType(parameter);
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        Msg.warn((Object)this, (Object)("No editor for " + String.valueOf(type) + "? Trying String instead"));
        editor = PropertyEditorManager.findEditor(String.class);
        return editor;
    }

    PropertyEditor getEditor(P parameter) {
        return (PropertyEditor)this.paramEditors.get(parameter);
    }

    protected void setEditorValue(PropertyEditor editor, P param, ValStr<?> val) {
        Object object = val.val();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigInteger.class}, (Object)object, n)) {
            case -1: {
                if (this.parameterType(param) != String.class) break;
                editor.setValue(val.str());
                break;
            }
            case 0: {
                BigInteger bi = (BigInteger)object;
                editor.setAsText(val.str());
                break;
            }
            default: {
                editor.setValue(val.val());
            }
        }
    }

    void populateOptions() {
        this.pairPanel.removeAll();
        this.paramEditors.clear();
        for (P param : this.parameters.values()) {
            JLabel label = new JLabel(this.parameterLabel(param));
            label.setToolTipText(this.parameterToolTip(param));
            this.pairPanel.add(label);
            PropertyEditor editor = this.createEditor(param);
            ValStr<?> val = this.computeInitialValue(param);
            this.setEditorValue(editor, param, val);
            editor.addPropertyChangeListener(this);
            this.pairPanel.add(MiscellaneousUtils.getEditorComponent(editor));
            this.paramEditors.put(param, (Object)editor);
        }
    }

    void populateValues(Map<String, ValStr<?>> values) {
        for (Map.Entry<String, ValStr<?>> ent : values.entrySet()) {
            P param = this.parameters.get(ent.getKey());
            if (param == null) continue;
            PropertyEditor editor = (PropertyEditor)this.paramEditors.get(param);
            this.setEditorValue(editor, param, ent.getValue());
        }
    }

    protected Map<String, ValStr<?>> collectArguments() {
        LinkedHashMap map = new LinkedHashMap();
        LinkedHashSet<String> invalid = new LinkedHashSet<String>();
        for (Map.Entry ent : this.paramEditors.entrySet()) {
            Object param = ent.getKey();
            PropertyEditor editor = (PropertyEditor)ent.getValue();
            ValStr<?> val = this.memorized.get(this.parameterNameAndType(param));
            if (!Objects.equals(editor.getAsText(), val.str())) {
                invalid.add(this.parameterLabel(param));
            }
            if (val == null) continue;
            map.put(this.parameterName(param), val);
        }
        if (!invalid.isEmpty()) {
            throw new IllegalStateException("Invalid value for " + String.valueOf(invalid));
        }
        return map;
    }

    public Map<String, ValStr<?>> getArguments() {
        return this.arguments;
    }

    void setMemorizedArgument(P parameter, ValStr<?> value) {
        if (value == null) {
            return;
        }
        this.memorized.put(this.parameterNameAndType(parameter), value);
        PropertyEditor editor = (PropertyEditor)this.paramEditors.get(parameter);
        if (editor != null) {
            this.setEditorValue(editor, parameter, value);
        }
    }

    public void forgetMemorizedArguments() {
        this.memorized.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor editor = (PropertyEditor)evt.getSource();
        Object param = this.paramEditors.getKey((Object)editor);
        this.memorized.put(this.parameterNameAndType(param), new ValStr(editor.getValue(), editor.getAsText()));
    }

    public void writeConfigState(SaveState saveState) {
        SaveState subState = new SaveState();
        for (Map.Entry<NameTypePair, ValStr<?>> ent : this.memorized.entrySet()) {
            NameTypePair ntp = ent.getKey();
            P param = this.parameters.get(ntp.name());
            if (param == null) continue;
            this.parameterSaveValue(param, subState, ntp.encodeString(), ent.getValue());
        }
        saveState.putSaveState(KEY_MEMORIZED_ARGUMENTS, subState);
    }

    public void readConfigState(SaveState saveState) {
        SaveState subState = saveState.getSaveState(KEY_MEMORIZED_ARGUMENTS);
        if (subState == null) {
            return;
        }
        for (String name : subState.getNames()) {
            try {
                NameTypePair ntp = NameTypePair.fromString(name);
                P param = this.parameters.get(ntp.name());
                if (param == null) continue;
                this.memorized.put(ntp, this.parameterLoadValue(param, subState, ntp.encodeString()));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Error restoring memorized parameter " + name), (Throwable)e);
            }
        }
    }

    public void setDescription(String htmlDescription) {
        if (htmlDescription == null) {
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder());
            this.descriptionLabel.setText("");
        } else {
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.descriptionLabel.setText(htmlDescription);
        }
    }

    static {
        PropertyEditorManager.registerEditor(BigInteger.class, BigIntEditor.class);
        PropertyEditorManager.registerEditor(Path.class, PathEditor.class);
        PropertyEditorManager.registerEditor(AutoConfigState.PathIsDir.class, PathIsDirEditor.class);
        PropertyEditorManager.registerEditor(AutoConfigState.PathIsFile.class, PathIsFileEditor.class);
    }

    protected record NameTypePair(String name, Class<?> type) {
        public static NameTypePair fromString(String name) throws ClassNotFoundException {
            String[] parts = name.split(",", 2);
            if (parts.length != 2) {
                return new NameTypePair(parts[0], String.class);
            }
            return new NameTypePair(parts[0], Class.forName(parts[1]));
        }

        public final String encodeString() {
            return this.name + "," + this.type.getName();
        }
    }

    static class ChoicesPropertyEditor
    implements PropertyEditor {
        private final List<?> choices;
        private final String[] tags;
        private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
        private Object value;

        public ChoicesPropertyEditor(Collection<?> choices) {
            this.choices = choices.stream().distinct().toList();
            this.tags = (String[])choices.stream().map(Objects::toString).toArray(String[]::new);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(Object value) {
            List<PropertyChangeListener> listeners;
            Object oldValue;
            if (Objects.equals(value, this.value)) {
                return;
            }
            if (!this.choices.contains(value)) {
                throw new IllegalArgumentException("Unsupported value: " + String.valueOf(value));
            }
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                oldValue = this.value;
                this.value = value;
                if (this.listeners.isEmpty()) {
                    return;
                }
                listeners = List.copyOf(this.listeners);
            }
            PropertyChangeEvent evt = new PropertyChangeEvent(this, null, oldValue, value);
            for (PropertyChangeListener l : listeners) {
                l.propertyChange(evt);
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
        }

        @Override
        public String getJavaInitializationString() {
            if (this.value == null) {
                return "null";
            }
            Object object = this.value;
            if (object instanceof String) {
                String str = (String)object;
                return "\"" + StringEscapeUtils.escapeJava((String)str) + "\"";
            }
            return Objects.toString(this.value);
        }

        @Override
        public String getAsText() {
            return Objects.toString(this.value);
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            int index = ArrayUtils.indexOf((Object[])this.tags, (Object)text);
            if (index < 0) {
                throw new IllegalArgumentException("Unsupported value: " + text);
            }
            this.setValue(this.choices.get(index));
        }

        @Override
        public String[] getTags() {
            return (String[])this.tags.clone();
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    public static class BigIntEditor
    extends PropertyEditorSupport {
        String asText = "";

        @Override
        public String getJavaInitializationString() {
            Object value = this.getValue();
            return value == null ? "null" : "new BigInteger(\"%s\")".formatted(value);
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            this.asText = text;
            this.setValueNoAsText(text == null ? null : NumericUtilities.decodeBigInteger((String)text));
        }

        public void setValueNoAsText(Object value) {
            super.setValue(value);
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            this.asText = value == null ? "" : value.toString();
        }

        @Override
        public String getAsText() {
            return this.asText;
        }
    }

    public static class PathEditor
    extends PropertyEditorSupport {
        private final FileChooserPanel panel = this.newChooserPanel();

        protected FileChooserPanel newChooserPanel() {
            return new FileChooserPanel(this::firePropertyChange);
        }

        @Override
        public String getAsText() {
            return this.panel.textField.getText().trim();
        }

        @Override
        public Object getValue() {
            String text = this.panel.textField.getText().trim();
            if (text.isEmpty()) {
                return null;
            }
            return Paths.get(text, new String[0]);
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null || text.isBlank()) {
                this.panel.textField.setText("");
            } else {
                this.panel.textField.setText(text);
            }
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.panel.textField.setText("");
            } else if (value instanceof String) {
                String s = (String)value;
                this.panel.textField.setText(s);
            } else if (value instanceof Path) {
                Path p = (Path)value;
                this.panel.textField.setText(p.toString());
            } else {
                throw new IllegalArgumentException("value=" + String.valueOf(value));
            }
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return this.panel;
        }
    }

    public static class PathIsDirEditor
    extends PathEditor {
        @Override
        protected FileChooserPanel newChooserPanel() {
            return new FileChooserPanel(this::firePropertyChange){

                @Override
                protected String getTitle() {
                    return "Choose Directory";
                }

                @Override
                protected GhidraFileChooserMode getSelectionMode() {
                    return GhidraFileChooserMode.DIRECTORIES_ONLY;
                }
            };
        }

        @Override
        public Object getValue() {
            Object value = super.getValue();
            if (value == null) {
                return null;
            }
            if (value instanceof Path) {
                Path p = (Path)value;
                return new AutoConfigState.PathIsDir(p);
            }
            throw new AssertionError();
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof AutoConfigState.PathIsDir) {
                AutoConfigState.PathIsDir dir = (AutoConfigState.PathIsDir)value;
                super.setValue(dir.path());
            } else {
                super.setValue(value);
            }
        }
    }

    public static class PathIsFileEditor
    extends PathEditor {
        @Override
        protected FileChooserPanel newChooserPanel() {
            return new FileChooserPanel(this::firePropertyChange){

                @Override
                protected String getTitle() {
                    return "Choose File";
                }

                @Override
                protected GhidraFileChooserMode getSelectionMode() {
                    return GhidraFileChooserMode.FILES_ONLY;
                }
            };
        }

        @Override
        public Object getValue() {
            Object value = super.getValue();
            if (value == null) {
                return null;
            }
            if (value instanceof Path) {
                Path p = (Path)value;
                return new AutoConfigState.PathIsFile(p);
            }
            throw new AssertionError();
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof AutoConfigState.PathIsFile) {
                AutoConfigState.PathIsFile file = (AutoConfigState.PathIsFile)value;
                super.setValue(file.path());
            } else {
                super.setValue(value);
            }
        }
    }

    public static class FileChooserPanel
    extends JPanel {
        private static final int NUMBER_OF_COLUMNS = 20;
        private final JTextField textField = new JTextField(20);
        private final JButton browseButton = new BrowseButton();
        private final Runnable propertyChange;
        private GhidraFileChooser fileChooser;

        public FileChooserPanel(final Runnable propertyChange) {
            this.propertyChange = propertyChange;
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.textField);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.browseButton);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.textField.addActionListener(e -> propertyChange.run());
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    propertyChange.run();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    propertyChange.run();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    propertyChange.run();
                }
            });
            this.browseButton.addActionListener(e -> this.displayFileChooser());
        }

        public void setValue(File file) {
            this.textField.setText(file == null ? "" : file.getAbsolutePath());
        }

        private void displayFileChooser() {
            File chosen;
            String path;
            if (this.fileChooser == null) {
                this.fileChooser = this.createFileChooser();
            }
            if (!(path = this.textField.getText().trim()).isEmpty()) {
                File f = new File(path);
                if (f.isDirectory()) {
                    this.fileChooser.setCurrentDirectory(f);
                } else {
                    File pf = f.getParentFile();
                    if (pf != null && pf.isDirectory()) {
                        this.fileChooser.setSelectedFile(f);
                    }
                }
            }
            if ((chosen = this.fileChooser.getSelectedFile(true)) != null) {
                this.textField.setText(chosen.getAbsolutePath());
                this.propertyChange.run();
            }
        }

        protected String getTitle() {
            return "Choose Path";
        }

        protected GhidraFileChooserMode getSelectionMode() {
            return GhidraFileChooserMode.FILES_AND_DIRECTORIES;
        }

        private GhidraFileChooser createFileChooser() {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this.browseButton);
            chooser.setTitle(this.getTitle());
            chooser.setApproveButtonText(this.getTitle());
            chooser.setFileSelectionMode(this.getSelectionMode());
            return chooser;
        }
    }
}

