/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.console;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.debug.api.progress.MonitorReceiver;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;

public class MonitorCellRenderer
extends JPanel
implements GColumnRenderer<MonitorReceiver> {
    static final MonitorCellRenderer INSTANCE = new MonitorCellRenderer();
    private static final Color BACKGROUND_COLOR = new GColor("color.bg.table.row");
    private static final Color ALT_BACKGROUND_COLOR = new GColor("color.bg.table.row.alt");
    private static final String DISABLE_ALTERNATING_ROW_COLORS_PROPERTY = "disable.alternating.row.colors";
    protected CachedColor selFg = new CachedColor();
    protected CachedColor selBg = new CachedColor();
    protected final Border focusBorder;
    protected final Border noFocusBorder;
    protected final JProgressBar bar = new JProgressBar();
    protected final JLabel label = new JLabel();

    private static boolean getAlternateRowColors() {
        return !Boolean.getBoolean(DISABLE_ALTERNATING_ROW_COLORS_PROPERTY);
    }

    public MonitorCellRenderer() {
        super(new BorderLayout());
        this.noFocusBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        Border innerBorder = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        Border outerBorder = BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.Palette.YELLOW, 1);
        this.focusBorder = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        this.add(this.bar);
        this.add((Component)this.label, "South");
    }

    protected Color getAlternatingBackgroundColor(int row) {
        if (!MonitorCellRenderer.getAlternateRowColors() || (row & 1) == 1) {
            return BACKGROUND_COLOR;
        }
        return ALT_BACKGROUND_COLOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        if (isSelected) {
            this.setForeground(this.selFg.copy(table.getSelectionForeground()));
            this.label.setForeground(this.selFg.copy(table.getSelectionForeground()));
            this.setBackground(this.selBg.copy(table.getSelectionBackground()));
        } else {
            this.setForeground(table.getForeground());
            this.label.setForeground(table.getForeground());
            this.setBackground(this.getAlternatingBackgroundColor(row));
        }
        this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
        if (!(value instanceof MonitorReceiver)) {
            return this;
        }
        MonitorReceiver monitor = (MonitorReceiver)value;
        if (monitor.isCancelled()) {
            this.label.setText("(cancelled) " + monitor.getMessage());
        } else {
            this.label.setText(monitor.getMessage());
        }
        StringBuilder sb = new StringBuilder();
        long progress = monitor.getProgress();
        long maximum = monitor.getMaximum();
        if (progress != -1L) {
            if (progress <= 0L) {
                sb.append("0%");
            } else if (progress >= maximum) {
                sb.append("100%");
            } else {
                sb.append(NumberFormat.getPercentInstance().format((float)progress / (float)maximum));
            }
            if (monitor.isShowProgressValue()) {
                sb.append(" (");
                sb.append(progress);
                sb.append(" of ");
                sb.append(maximum);
                sb.append(")");
            }
        }
        this.bar.setString(sb.toString());
        this.bar.setStringPainted(true);
        BoundedRangeModel model = this.bar.getModel();
        try {
            model.setValueIsAdjusting(true);
            model.setMaximum(Integer.MAX_VALUE);
            if (progress == -1L) {
                this.bar.setIndeterminate(true);
                model.setValue(0);
            } else {
                this.bar.setIndeterminate(monitor.isIndeterminate());
                double val = 2.147483647E9;
                val *= (double)progress;
                model.setValue((int)(val /= (double)maximum));
            }
        }
        finally {
            model.setValueIsAdjusting(false);
        }
        return this;
    }

    public String getFilterString(MonitorReceiver t, Settings settings) {
        return t.getMessage();
    }

    static class CachedColor {
        Color cached;

        CachedColor() {
        }

        Color copy(Color c) {
            if (this.cached == null || this.cached.getRGB() != c.getRGB()) {
                this.cached = new Color(c.getRGB());
            }
            return this.cached;
        }
    }
}

