/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.MultiProviderSaveBehavior;
import ghidra.app.plugin.core.debug.gui.model.DebuggerModelProvider;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PluginInfo(shortDescription="Debugger model browser", description="GUI to browse objects recorded to the trace", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class})
public class DebuggerModelPlugin
extends Plugin {
    private DebuggerModelProvider connectedProvider;
    private final List<DebuggerModelProvider> disconnectedProviders = new ArrayList<DebuggerModelProvider>();
    private final ForModelMultiProviderSaveBehavior saveBehavior = new ForModelMultiProviderSaveBehavior();

    public DebuggerModelPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.connectedProvider = this.newProvider(false);
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.connectedProvider);
        List<DebuggerModelProvider> list = this.disconnectedProviders;
        synchronized (list) {
            for (DebuggerModelProvider p : this.disconnectedProviders) {
                this.tool.removeComponentProvider((ComponentProvider)p);
            }
        }
        super.dispose();
    }

    protected DebuggerModelProvider newProvider(boolean isClone) {
        return new DebuggerModelProvider(this, isClone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DebuggerModelProvider createDisconnectedProvider() {
        DebuggerModelProvider p = this.newProvider(true);
        List<DebuggerModelProvider> list = this.disconnectedProviders;
        synchronized (list) {
            this.disconnectedProviders.add(p);
        }
        return p;
    }

    public DebuggerModelProvider getConnectedProvider() {
        return this.connectedProvider;
    }

    public List<DebuggerModelProvider> getDisconnectedProviders() {
        return Collections.unmodifiableList(this.disconnectedProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coordinatesActivated(DebuggerCoordinates current) {
        this.connectedProvider.coordinatesActivated(current);
        List<DebuggerModelProvider> list = this.disconnectedProviders;
        synchronized (list) {
            for (DebuggerModelProvider p : this.disconnectedProviders) {
                p.coordinatesActivated(current);
            }
        }
    }

    public void processEvent(PluginEvent event) {
        PluginEvent ev;
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates());
        }
        if (event instanceof TraceClosedPluginEvent) {
            ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceClosed(Trace trace) {
        this.connectedProvider.traceClosed(trace);
        List<DebuggerModelProvider> list = this.disconnectedProviders;
        synchronized (list) {
            for (DebuggerModelProvider p : this.disconnectedProviders) {
                p.traceClosed(trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void providerRemoved(DebuggerModelProvider p) {
        List<DebuggerModelProvider> list = this.disconnectedProviders;
        synchronized (list) {
            this.disconnectedProviders.remove(p);
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.saveBehavior.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        this.saveBehavior.readConfigState(saveState);
    }

    public void writeDataState(SaveState saveState) {
        this.saveBehavior.writeDataState(saveState);
    }

    public void readDataState(SaveState saveState) {
        this.saveBehavior.readDataState(saveState);
    }

    private final class ForModelMultiProviderSaveBehavior
    extends MultiProviderSaveBehavior<DebuggerModelProvider> {
        private ForModelMultiProviderSaveBehavior() {
        }

        @Override
        protected DebuggerModelProvider getConnectedProvider() {
            return DebuggerModelPlugin.this.connectedProvider;
        }

        @Override
        protected List<DebuggerModelProvider> getDisconnectedProviders() {
            return DebuggerModelPlugin.this.disconnectedProviders;
        }

        @Override
        protected DebuggerModelProvider createDisconnectedProvider() {
            return DebuggerModelPlugin.this.createDisconnectedProvider();
        }

        @Override
        protected void removeDisconnectedProvider(DebuggerModelProvider p) {
            p.removeFromTool();
        }
    }
}

