/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.ColorsModified;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Trace;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class TracePathValueColumn
extends AbstractDynamicTableColumn<PathTableModel.PathRow, PathTableModel.PathRow, Trace> {
    private Color diffColor = DebuggerResources.COLOR_VALUE_CHANGED;
    private Color diffColorSel = DebuggerResources.COLOR_VALUE_CHANGED_SEL;

    public String getColumnName() {
        return "Value";
    }

    public PathTableModel.PathRow getValue(PathTableModel.PathRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return rowObject;
    }

    public GColumnRenderer<PathTableModel.PathRow> getColumnRenderer() {
        return new ValueRenderer();
    }

    public void setDiffColor(Color diffColor) {
        this.diffColor = diffColor;
    }

    public void setDiffColorSel(Color diffColorSel) {
        this.diffColorSel = diffColorSel;
    }

    private final class ValueRenderer
    extends AbstractGColumnRenderer<PathTableModel.PathRow>
    implements ColorsModified.InTable {
        private ValueRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public String getFilterString(PathTableModel.PathRow t, Settings settings) {
            return t.getDisplay();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            PathTableModel.PathRow row = (PathTableModel.PathRow)data.getValue();
            this.setText(row.getHtmlDisplay());
            this.setToolTipText(row.getToolTip());
            this.setForeground(this.getForegroundFor(data.getTable(), row.isModified(), data.isSelected()));
            if (row.isCurrent()) {
                this.setBold();
            }
            return this;
        }

        @Override
        public Color getDiffForeground(JTable table) {
            return TracePathValueColumn.this.diffColor;
        }

        @Override
        public Color getDiffSelForeground(JTable table) {
            return TracePathValueColumn.this.diffColorSel;
        }
    }
}

