/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.trace;

import docking.Tool;
import docking.action.DockingAction;
import docking.widgets.tab.GTabPanel;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerTraceFileActionContext;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectDisplayUtils;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.trace.model.Trace;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Swing;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import utilities.util.SuppressableCallback;

public class DebuggerTraceTabPanel
extends GTabPanel<Trace>
implements PluginEventListener,
DomainObjectListener {
    DebuggerTargetService targetService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private final TargetsChangeListener targetsListener = new TargetsChangeListener();
    DockingAction actionCloseTrace;
    DockingAction actionCloseOtherTraces;
    DockingAction actionCloseDeadTraces;
    DockingAction actionCloseAllTraces;
    private final SuppressableCallback<Void> cbCoordinateActivation = new SuppressableCallback();

    public DebuggerTraceTabPanel(Plugin plugin) {
        super("Trace");
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        PluginTool tool = plugin.getTool();
        tool.addEventListener(TraceOpenedPluginEvent.class, (PluginEventListener)this);
        tool.addEventListener(TraceActivatedPluginEvent.class, (PluginEventListener)this);
        tool.addEventListener(TraceClosedPluginEvent.class, (PluginEventListener)this);
        this.setNameFunction(this::getNameForTrace);
        this.setIconFunction(this::getIconForTrace);
        this.setToolTipFunction(this::getTipForTrace);
        this.setSelectedTabConsumer(this::traceTabSelected);
        this.setCloseTabConsumer(t -> this.traceManager.closeTrace(t));
        this.actionCloseTrace = (DockingAction)DebuggerResources.CloseTraceAction.builderPopup(plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> {
            Trace trace = c.getTrace();
            if (trace == null) {
                return false;
            }
            this.actionCloseTrace.getPopupMenuData().setMenuItemName("Close " + this.getNameForTrace(trace));
            return true;
        }).onAction(c -> this.traceManager.closeTrace(c.getTrace())).buildAndInstall((Tool)tool);
        this.actionCloseAllTraces = (DockingAction)DebuggerResources.CloseAllTracesAction.builderPopup(plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> this.traceManager != null && !this.traceManager.getOpenTraces().isEmpty()).onAction(c -> this.traceManager.closeAllTraces()).buildAndInstall((Tool)tool);
        this.actionCloseOtherTraces = (DockingAction)DebuggerResources.CloseOtherTracesAction.builderPopup(plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> this.traceManager != null && this.traceManager.getOpenTraces().size() > 1 && c.getTrace() != null).onAction(c -> this.traceManager.closeOtherTraces(c.getTrace())).buildAndInstall((Tool)tool);
        this.actionCloseDeadTraces = (DockingAction)DebuggerResources.CloseDeadTracesAction.builderPopup(plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> this.traceManager != null && !this.traceManager.getOpenTraces().isEmpty() && this.targetService != null).onAction(c -> this.traceManager.closeDeadTraces()).buildAndInstall((Tool)tool);
    }

    private String getNameForTrace(Trace trace) {
        DebuggerCoordinates current;
        String name = DomainObjectDisplayUtils.getTabText((DomainObject)trace);
        DebuggerCoordinates debuggerCoordinates = current = this.traceManager == null ? DebuggerCoordinates.NOWHERE : this.traceManager.getCurrentFor(trace);
        if (current == DebuggerCoordinates.NOWHERE) {
            return name + " (?)";
        }
        TraceSchedule.TimeRadix radix = trace.getTimeManager().getTimeRadix();
        Object schedule = current.getTime().toString(radix);
        if (((String)schedule).length() > 15) {
            schedule = "..." + ((String)schedule).substring(((String)schedule).length() - 12);
        }
        return name + " (" + (String)schedule + ")";
    }

    private Icon getIconForTrace(Trace trace) {
        if (this.targetService == null) {
            return null;
        }
        Target target = this.targetService.getTarget(trace);
        if (target == null || !target.isValid()) {
            return null;
        }
        return DebuggerResources.ICON_RECORD;
    }

    private String getTipForTrace(Trace trace) {
        return DomainObjectDisplayUtils.getToolTip((DomainObject)trace);
    }

    public DebuggerTraceFileActionContext getActionContext(MouseEvent e) {
        if (e == null) {
            return null;
        }
        Trace trace = (Trace)this.getValueFor(e);
        if (trace == null) {
            return null;
        }
        return new DebuggerTraceFileActionContext(trace);
    }

    @AutoServiceConsumed
    public void setTargetService(DebuggerTargetService targetService) {
        if (this.targetService != null) {
            this.targetService.removeTargetPublicationListener((TargetPublicationListener)this.targetsListener);
        }
        this.targetService = targetService;
        if (this.targetService != null) {
            this.targetService.addTargetPublicationListener((TargetPublicationListener)this.targetsListener);
        }
    }

    protected void add(Trace trace) {
        this.addTab(trace);
        trace.removeListener((DomainObjectListener)this);
        trace.addListener((DomainObjectListener)this);
    }

    protected void remove(Trace trace) {
        trace.removeListener((DomainObjectListener)this);
        this.removeTab(trace);
    }

    public void eventSent(PluginEvent event) {
        if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent evt = (TraceOpenedPluginEvent)event;
            try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
                this.add(evt.getTrace());
            }
        }
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent evt = (TraceActivatedPluginEvent)event;
            Trace trace = evt.getActiveCoordinates().getTrace();
            try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
                this.selectTab(trace);
                this.refreshTab(trace);
            }
        }
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            Trace trace = evt.getTrace();
            try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
                this.remove(trace);
            }
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        Object object = ev.getSource();
        if (object instanceof Trace) {
            Trace trace = (Trace)object;
            this.refreshTab(trace);
        }
    }

    private void traceTabSelected(Trace newTrace) {
        this.cbCoordinateActivation.invoke(() -> {
            if (this.traceManager == null) {
                return;
            }
            this.traceManager.activateTrace(newTrace);
        });
    }

    private class TargetsChangeListener
    implements TargetPublicationListener {
        private TargetsChangeListener() {
        }

        public void targetPublished(Target target) {
            Swing.runIfSwingOrRunLater(() -> DebuggerTraceTabPanel.this.refreshTab(target.getTrace()));
        }

        public void targetWithdrawn(Target target) {
            Swing.runIfSwingOrRunLater(() -> DebuggerTraceTabPanel.this.refreshTab(target.getTrace()));
        }
    }
}

