/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.framework.options.PropertyBoolean;
import ghidra.framework.options.PropertySelector;
import ghidra.framework.options.PropertyText;
import ghidra.program.model.address.AddressRange;
import ghidra.util.MathUtilities;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import java.math.BigInteger;

public final class MiscellaneousUtils
extends Enum<MiscellaneousUtils> {
    public static final String HEX_BIT64;
    private static final /* synthetic */ MiscellaneousUtils[] $VALUES;

    public static MiscellaneousUtils[] values() {
        return (MiscellaneousUtils[])$VALUES.clone();
    }

    public static MiscellaneousUtils valueOf(String name) {
        return Enum.valueOf(MiscellaneousUtils.class, name);
    }

    public static Component getEditorComponent(PropertyEditor editor) {
        if (editor.supportsCustomEditor()) {
            return editor.getCustomEditor();
        }
        if (editor.getValue() instanceof Boolean) {
            return new PropertyBoolean(editor);
        }
        if (editor.getTags() != null) {
            return new PropertySelector(editor);
        }
        if (editor.getAsText() != null) {
            return new PropertyText(editor);
        }
        return new PropertyText(editor);
    }

    public static void rigFocusAndEnter(Component c, final Runnable runnable) {
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                runnable.run();
            }
        });
        c.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    runnable.run();
                }
            }
        });
    }

    public static long lengthMin(long a, long b) {
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        return MathUtilities.unsignedMin((long)a, (long)b);
    }

    public static String lengthToString(long length) {
        return length == 0L ? HEX_BIT64 : "0x" + Long.toHexString(length);
    }

    public static long parseLength(String text, long defaultVal) {
        BigInteger bi;
        int radix;
        String post;
        if ((text = text.trim()).startsWith("-")) {
            return 0L;
        }
        if (text.startsWith("0x")) {
            post = text.substring(2);
            radix = 16;
        } else {
            post = text;
            radix = 10;
        }
        try {
            bi = new BigInteger(post, radix);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
        if (bi.equals(BigInteger.ZERO)) {
            return 1L;
        }
        if (bi.bitLength() > 64) {
            return 0L;
        }
        return bi.longValue();
    }

    public static long revalidateLengthByRange(AddressRange range, long length) {
        long maxLength = range.getAddressSpace().getMaxAddress().subtract(range.getMinAddress()) + 1L;
        return MiscellaneousUtils.lengthMin(length, maxLength);
    }

    private static /* synthetic */ MiscellaneousUtils[] $values() {
        return new MiscellaneousUtils[0];
    }

    static {
        $VALUES = MiscellaneousUtils.$values();
        HEX_BIT64 = "0x" + BigInteger.ONE.shiftLeft(64).toString(16);
    }
}

