/*
 * Decompiled with CFR 0.152.
 */
package sarif.view;

import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.service.graph.AttributedVertex;
import ghidra.util.table.GhidraFilterTable;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sarif.SarifController;
import sarif.handlers.SarifResultHandler;
import sarif.model.SarifColumnKey;
import sarif.model.SarifDataFrame;
import sarif.model.SarifResultsTableModelFactory;

public class SarifResultsTableProvider
extends ComponentProvider {
    private JComponent component;
    public SarifResultsTableModelFactory.SarifResultsTableModel model;
    public GhidraFilterTable<Map<String, Object>> filterTable;
    public Program program;
    private Plugin plugin;
    private SarifController controller;

    public SarifResultsTableProvider(String description, Plugin plugin, SarifController controller, SarifDataFrame df) {
        super((Tool)plugin.getTool(), controller.getProgram().getName(), plugin.getName());
        this.plugin = plugin;
        this.controller = controller;
        this.program = controller.getProgram();
        SarifResultsTableModelFactory factory = new SarifResultsTableModelFactory(df.getColumns());
        this.model = factory.createModel(description, plugin.getTool(), this.program, df);
        this.component = this.buildPanel();
        this.filterTable.getTable().getSelectionModel().addListSelectionListener(e -> plugin.getTool().contextChanged((ComponentProvider)this));
        this.createActions();
        this.setTransient();
    }

    private JComponent buildPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.filterTable = new GhidraFilterTable((RowObjectTableModel)this.model);
        GhidraTable table = this.filterTable.getTable();
        GoToService goToService = (GoToService)this.getTool().getService(GoToService.class);
        table.installNavigation((ServiceProvider)this.plugin.getTool(), goToService.getDefaultNavigatable());
        table.setNavigateOnSelectionEnabled(true);
        panel.add((Component)this.filterTable);
        return panel;
    }

    public void dispose() {
        this.filterTable.dispose();
        this.closeComponent();
    }

    public void closeComponent() {
        super.closeComponent();
        this.getController().removeProvider(this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void createActions() {
        MakeProgramSelectionAction selectionAction = new MakeProgramSelectionAction(this.plugin, this.filterTable.getTable());
        this.addLocalAction((DockingActionIf)selectionAction);
        Set<SarifResultHandler> resultHandlers = this.controller.getSarifResultHandlers();
        List<SarifColumnKey> columns = this.model.getDataFrame().getColumns();
        ArrayList<String> keyNames = new ArrayList<String>();
        for (SarifColumnKey key : columns) {
            keyNames.add(key.getName());
        }
        for (SarifResultHandler handler : resultHandlers) {
            if (!keyNames.contains(handler.getKey()) || handler.getActionName() == null) continue;
            this.addLocalAction((DockingActionIf)handler.createAction(this));
        }
    }

    public int getIndex(String key) {
        List<SarifColumnKey> columns = this.model.getDataFrame().getColumns();
        for (SarifColumnKey c : columns) {
            if (!c.getName().equals(key)) continue;
            columns.indexOf(c);
        }
        return -1;
    }

    public Object getValue(int x, int y) {
        return this.model.getColumnValueForRow((Map)this.model.getRowObject(x), y);
    }

    public Map<String, Object> getRow(int x) {
        return (Map)this.model.getRowObject(x);
    }

    public SarifController getController() {
        return this.controller;
    }

    public SarifDataFrame getDataFrame() {
        return this.model.getDataFrame();
    }

    public void setSelection(Set<AttributedVertex> vertices) {
        for (AttributedVertex vertex : vertices) {
            Map attributes = vertex.getAttributes();
            if (!attributes.containsKey("Address")) continue;
            String addrStr = (String)attributes.get("Address");
            String name = (String)attributes.get("name");
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                Map rowObject;
                String objName;
                Address address = this.model.getAddress(i);
                if (address == null || !address.toString(true).equals(addrStr) || !name.equals(objName = (String)(rowObject = (Map)this.model.getRowObject(i)).get("name"))) continue;
                this.filterTable.getTable().selectRow(i);
                this.filterTable.getTable().scrollToSelectedRow();
            }
        }
    }
}

