/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class OperandValue
extends PatternValue {
    private int index;
    private Constructor ct;

    public OperandValue(Location location) {
        super(location);
    }

    public OperandValue(Location location, int ind, Constructor c) {
        super(location);
        this.index = ind;
        this.ct = c;
    }

    public void changeIndex(int newind) {
        this.index = newind;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        if (this.index >= ops.size()) {
            return null;
        }
        return (TokenPattern)ops.get(this.index);
    }

    @Override
    public TokenPattern genPattern(long val) {
        throw new SleighError("Operand used in pattern expression", this.ct.location);
    }

    @Override
    public long minValue() {
        throw new SleighError("Operand used in pattern expression", this.ct.location);
    }

    @Override
    public long maxValue() {
        throw new SleighError("Operand used in pattern expression", this.ct.location);
    }

    @Override
    public long getSubValue(VectorSTL<Long> replace, MutableInt listpos) {
        OperandSymbol sym = this.ct.getOperand(this.index);
        return sym.getDefiningExpression().getSubValue(replace, listpos);
    }

    public boolean isConstructorRelative() {
        OperandSymbol sym = this.ct.getOperand(this.index);
        return sym.getOffsetBase() == -1;
    }

    public String getName() {
        OperandSymbol sym = this.ct.getOperand(this.index);
        return sym.getName();
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_OPERAND_EXP);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_INDEX, this.index);
        int id = this.ct == null ? 0 : this.ct.getParent().getId();
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_TABLE, id);
        long ctid = this.ct == null ? 0L : this.ct.getId();
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_CT, ctid);
        encoder.closeElement(SlaFormat.ELEM_OPERAND_EXP);
    }
}

