/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.ProtoDBAdapter;
import ghidra.program.database.code.PrototypeManager;
import ghidra.program.database.util.DatabaseVersionException;
import java.io.IOException;

class ProtoDBAdapterV0
implements ProtoDBAdapter {
    private Table table;

    ProtoDBAdapterV0(DBHandle handle) throws DatabaseVersionException {
        this.table = handle.getTable("Prototypes");
        this.testVersion(0);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void testVersion(int expectedVersion) throws DatabaseVersionException {
        if (this.table == null) {
            throw new DatabaseVersionException("Instruction table not found");
        }
        int versionNumber = this.table.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new DatabaseVersionException("Prototype table: Expected Version " + expectedVersion + ", got " + versionNumber);
        }
    }

    @Override
    public void createRecord(int protoID, long addr, byte[] b, boolean inDelaySlot) throws IOException {
        throw new UnsupportedOperationException("Cannot create records with old schema");
    }

    @Override
    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getKey() throws IOException {
        return this.table.getKey();
    }

    @Override
    public int getNumRecords() throws IOException {
        return this.table.getRecordCount();
    }

    @Override
    public DBRecord getRecord(int protoId) throws IOException {
        return this.convertRecord(this.table.getRecord((long)protoId));
    }

    private DBRecord convertRecord(DBRecord oldRec) {
        long key = oldRec.getKey();
        if (key < 0L) {
            key = -key;
        }
        DBRecord newRec = PrototypeManager.PROTO_SCHEMA.createRecord(key);
        newRec.setBinaryData(0, oldRec.getBinaryData(0));
        newRec.setLongValue(1, oldRec.getLongValue(1));
        newRec.setBooleanValue(2, false);
        return newRec;
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new RecordUpdateIterator(this.table.iterator());
    }

    class RecordUpdateIterator
    implements RecordIterator {
        RecordIterator it;

        RecordUpdateIterator(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            return ProtoDBAdapterV0.this.convertRecord(this.it.next());
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            long key = rec.getKey();
            if (key < 0L) {
                key = -key;
            }
            DBRecord newRec = PrototypeManager.PROTO_SCHEMA.createRecord(key);
            newRec.setBinaryData(0, rec.getBinaryData(0));
            newRec.setLongValue(1, rec.getLongValue(1));
            newRec.setBooleanValue(2, false);
            return newRec;
        }
    }
}

