/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBRecord;
import db.Field;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldFunctionDBAdapter;
import ghidra.program.database.oldfunction.OldFunctionManager;
import ghidra.program.database.oldfunction.OldFunctionParameter;
import ghidra.program.database.oldfunction.OldRegisterVariableDBAdapter;
import ghidra.program.database.oldfunction.OldStackFrameDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class OldFunctionDataDB {
    private AddressMap addrMap;
    private OldFunctionManager functionManager;
    private ProgramDB program;
    private OldFunctionDBAdapter functionAdapter;
    private OldRegisterVariableDBAdapter registerAdapter;
    private DBRecord functionRecord;
    private Address entryPoint;
    private AddressSetView body;
    private OldStackFrameDB frame;
    private List<Parameter> regParams;

    OldFunctionDataDB(OldFunctionManager functionManager, AddressMap addrMap, DBRecord functionRecord, AddressSetView body) {
        this.functionManager = functionManager;
        this.addrMap = addrMap;
        this.functionRecord = functionRecord;
        this.body = body;
        this.entryPoint = addrMap.decodeAddress(functionRecord.getKey());
        this.program = functionManager.getProgram();
        this.functionAdapter = functionManager.getFunctionAdapter();
        this.registerAdapter = functionManager.getRegisterVariableAdapter();
        this.frame = new OldStackFrameDB(this);
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    OldFunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public Program getProgram() {
        return this.program;
    }

    public synchronized String getComment() {
        CodeUnit cu = this.program.getCodeManager().getCodeUnitContaining(this.entryPoint);
        return cu.getComment(CommentType.PLATE);
    }

    public synchronized String[] getCommentAsArray() {
        return StringUtilities.toLines((String)this.getComment());
    }

    public String getRepeatableComment() {
        String comment = this.functionRecord.getString(5);
        return comment;
    }

    public String[] getRepeatableCommentAsArray() {
        String comment = this.getRepeatableComment();
        return StringUtilities.toLines((String)comment);
    }

    public synchronized Address getEntryPoint() {
        return this.entryPoint;
    }

    public AddressSetView getBody() {
        if (this.body == null) {
            this.body = this.functionManager.getFunctionBody(this.functionRecord.getKey());
        }
        return this.body;
    }

    public synchronized DataType getReturnType() {
        long typeId = this.functionRecord.getLongValue(0);
        DataType dt = this.functionManager.getDataType(typeId);
        if (dt == null) {
            dt = DataType.DEFAULT;
        }
        return dt;
    }

    public StackFrame getStackFrame() {
        return this.frame;
    }

    public int getStackDepthChange() {
        int value = this.functionRecord.getIntValue(1);
        return value;
    }

    public boolean isStackDepthValid() {
        return this.getStackDepthChange() <= 0xFFFFFF;
    }

    int getStackParamOffset() {
        return this.functionRecord.getIntValue(2);
    }

    int getStackReturnOffset() {
        return this.functionRecord.getIntValue(3);
    }

    int getStackLocalSize() {
        return this.functionRecord.getIntValue(4);
    }

    private synchronized void loadRegisterParameterList() {
        if (this.regParams != null) {
            return;
        }
        this.regParams = new ArrayList<Parameter>();
        try {
            Field[] keys = this.registerAdapter.getRegisterVariableKeys(this.functionRecord.getKey());
            for (int i = 0; i < keys.length; ++i) {
                DBRecord varRec = this.registerAdapter.getRegisterVariableRecord(keys[i].getLongValue());
                this.regParams.add(this.getRegisterParameter(varRec, i));
            }
        }
        catch (IOException e) {
            this.functionManager.dbError(e);
        }
    }

    private Parameter getRegisterParameter(DBRecord record, int ordinal) {
        String name = record.getString(3);
        long dataTypeId = record.getLongValue(2);
        String regName = record.getString(1);
        DataType dataType = this.functionManager.getDataType(dataTypeId);
        try {
            VariableStorage storage = VariableStorage.BAD_STORAGE;
            Register register = this.functionManager.getProgram().getProgramContext().getRegister(regName);
            if (register == null) {
                Msg.error((Object)this, (Object)("Invalid parameter, register not found: " + regName));
            } else {
                storage = new VariableStorage((ProgramArchitecture)this.program, register.getAddress(), dataType.getLength());
            }
            return new OldFunctionParameter(name, ordinal, dataType, storage, (Program)this.program, SourceType.USER_DEFINED);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Invalid parameter '" + name + "' in function at " + this.entryPoint.toString()));
            try {
                return new OldFunctionParameter(name, ordinal, dataType, VariableStorage.BAD_STORAGE, (Program)this.program, SourceType.USER_DEFINED);
            }
            catch (InvalidInputException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public synchronized Parameter[] getParameters() {
        this.loadRegisterParameterList();
        Parameter[] parms = new Parameter[this.regParams.size() + this.frame.getParameterCount()];
        int ordinal = 0;
        for (Parameter rp : this.regParams) {
            parms[ordinal++] = rp;
        }
        try {
            Variable[] stackParams;
            for (Variable stackParam : stackParams = this.frame.getParameters()) {
                parms[ordinal++] = new OldFunctionParameter(stackParam.getName(), ordinal, stackParam.getDataType(), stackParam.getVariableStorage(), (Program)this.program, SourceType.USER_DEFINED);
            }
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
        return parms;
    }

    public long getKey() {
        return this.functionRecord.getKey();
    }
}

