/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import db.DBRecord;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.sourcemap.SourceMapEntry;
import java.util.Objects;

public class SourceMapEntryDB
implements SourceMapEntry {
    private int lineNumber;
    private SourceFile sourceFile;
    private Address baseAddress;
    private long length;
    private AddressRange range;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SourceMapEntryDB(SourceFileManagerDB manager, DBRecord record, AddressMapDB addrMap) {
        block5: {
            this.range = null;
            manager.lock.acquire();
            try {
                Address max;
                long fileAndLine = record.getLongValue(0);
                this.lineNumber = (int)(fileAndLine & 0xFFFFFFFFFFFFFFFFL);
                this.sourceFile = manager.getSourceFile(fileAndLine >> 32);
                long encodedAddress = record.getLongValue(1);
                this.baseAddress = addrMap.decodeAddress(encodedAddress);
                this.length = record.getLongValue(2);
                if (this.length == 0L) break block5;
                try {
                    max = this.baseAddress.addNoWrap(this.length - 1L);
                }
                catch (AddressOverflowException e) {
                    max = this.baseAddress.getAddressSpace().getMaxAddress();
                }
                this.range = new AddressRangeImpl(this.baseAddress, max);
            }
            finally {
                manager.lock.release();
            }
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public Address getBaseAddress() {
        return this.baseAddress;
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getSourceFile().toString());
        sb.append(":");
        sb.append(this.getLineNumber());
        sb.append(" @ ");
        sb.append(this.getBaseAddress().toString());
        sb.append(" (");
        sb.append(Long.toString(this.getLength()));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(SourceMapEntry o) {
        int sourceFileCompare = this.getSourceFile().compareTo(o.getSourceFile());
        if (sourceFileCompare != 0) {
            return sourceFileCompare;
        }
        int lineCompare = Integer.compare(this.getLineNumber(), o.getLineNumber());
        if (lineCompare != 0) {
            return lineCompare;
        }
        int addrCompare = this.getBaseAddress().compareTo(o.getBaseAddress());
        if (addrCompare != 0) {
            return addrCompare;
        }
        return Long.compareUnsigned(this.getLength(), o.getLength());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceMapEntry)) {
            return false;
        }
        SourceMapEntry otherEntry = (SourceMapEntry)o;
        if (this.lineNumber != otherEntry.getLineNumber()) {
            return false;
        }
        if (!this.sourceFile.equals(otherEntry.getSourceFile())) {
            return false;
        }
        if (!this.baseAddress.equals(otherEntry.getBaseAddress())) {
            return false;
        }
        if (this.length != otherEntry.getLength()) {
            return false;
        }
        return Objects.equals(this.range, otherEntry.getRange());
    }

    public int hashCode() {
        int hashCode = this.lineNumber;
        hashCode = 31 * hashCode + this.sourceFile.hashCode();
        hashCode = 31 * hashCode + this.baseAddress.hashCode();
        hashCode = 31 * hashCode + Long.hashCode(this.length);
        return hashCode;
    }
}

