/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;

public class AddressRangeSplitter
implements AddressRangeIterator {
    private AddressRange remainingRange;
    private int splitSize;
    private boolean forward;

    public AddressRangeSplitter(AddressRange range, int splitSize, boolean forward) {
        this.remainingRange = range;
        this.splitSize = splitSize;
        this.forward = forward;
    }

    @Override
    public boolean hasNext() {
        return this.remainingRange != null;
    }

    @Override
    public AddressRange next() {
        if (this.remainingRange == null) {
            return null;
        }
        if (this.isRangeSmallEnough()) {
            AddressRange returnValue = this.remainingRange;
            this.remainingRange = null;
            return returnValue;
        }
        return this.forward ? this.extractChunkFromStart() : this.extractChunkFromEnd();
    }

    private AddressRange extractChunkFromStart() {
        Address start = this.remainingRange.getMinAddress();
        Address end = start.add(this.splitSize - 1);
        this.remainingRange = new AddressRangeImpl(end.next(), this.remainingRange.getMaxAddress());
        return new AddressRangeImpl(start, end);
    }

    private AddressRange extractChunkFromEnd() {
        Address end = this.remainingRange.getMaxAddress();
        Address start = end.subtract(this.splitSize - 1);
        this.remainingRange = new AddressRangeImpl(this.remainingRange.getMinAddress(), start.previous());
        return new AddressRangeImpl(start, end);
    }

    private boolean isRangeSmallEnough() {
        try {
            int size = this.remainingRange.getBigLength().intValueExact();
            return size <= this.splitSize;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }
}

