/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DynamicDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.Serializable;

public class ReadOnlyDataTypeComponent
implements DataTypeComponent,
Serializable {
    private final DataType dataType;
    private final DynamicDataType parent;
    private final int offset;
    private final int ordinal;
    private final String comment;
    private final int length;
    private String fieldName;
    private Settings defaultSettings;

    public ReadOnlyDataTypeComponent(DataType dataType, DynamicDataType parent, int length, int ordinal, int offset, String fieldName, String comment) {
        this.dataType = dataType;
        this.parent = parent;
        this.ordinal = ordinal;
        this.offset = offset;
        this.length = length;
        this.fieldName = fieldName;
        this.comment = comment;
    }

    public ReadOnlyDataTypeComponent(DataType dataType, DynamicDataType parent, int length, int ordinal, int offset) {
        this(dataType, parent, length, ordinal, offset, null, null);
    }

    @Override
    public boolean isBitFieldComponent() {
        return this.dataType instanceof BitFieldDataType;
    }

    @Override
    public boolean isZeroBitFieldComponent() {
        if (this.dataType instanceof BitFieldDataType) {
            return ((BitFieldDataType)this.dataType).getBitSize() == 0;
        }
        return false;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.length - 1;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = this.getDefaultFieldName();
        }
        return this.fieldName;
    }

    @Override
    public void setFieldName(String fieldName) throws DuplicateNameException {
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataType getParent() {
        return this.parent;
    }

    @Override
    public int getLength() {
        if (this.length == 0) {
            return 1;
        }
        return this.length;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public Settings getDefaultSettings() {
        if (this.defaultSettings == null) {
            SettingsImpl settings = new SettingsImpl(true);
            settings.setDefaultSettings(this.dataType.getDefaultSettings());
            this.defaultSettings = settings;
        }
        return this.defaultSettings;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataTypeComponent)) {
            return false;
        }
        DataTypeComponent dtc = (DataTypeComponent)obj;
        if (this.offset != dtc.getOffset() || this.length != dtc.getLength() || this.ordinal != dtc.getOrdinal() || !this.dataType.isEquivalent(dtc.getDataType())) {
            return false;
        }
        return this.isSameString(this.fieldName, dtc.getFieldName()) && this.isSameString(this.comment, dtc.getComment());
    }

    @Override
    public boolean isEquivalent(DataTypeComponent dtc) {
        boolean aligned;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        int otherLength = dtc.getLength();
        DataType myParent = this.getParent();
        boolean bl = aligned = myParent instanceof Composite ? ((Composite)myParent).isPackingEnabled() : false;
        if (!aligned && this.offset != dtc.getOffset() || !aligned && this.length != otherLength || this.ordinal != dtc.getOrdinal() || !this.isSameString(this.getFieldName(), dtc.getFieldName()) || !this.isSameString(this.getComment(), dtc.getComment())) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(myDt, otherDt);
    }

    private boolean isSameString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    @Override
    public boolean isUndefined() {
        return this.dataType == DataType.DEFAULT;
    }
}

