/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.List;

public interface Group {
    public String getComment();

    public void setComment(String var1);

    public String getName();

    public void setName(String var1) throws DuplicateNameException;

    public boolean contains(CodeUnit var1);

    public int getNumParents();

    public ProgramModule[] getParents();

    public String[] getParentNames();

    public String getTreeName();

    public boolean isDeleted();

    public Address getMinAddress();

    public Address getMaxAddress();

    default public GroupPath getGroupPath() {
        List<String> parentNames = Group.getParentNames(this);
        return new GroupPath(parentNames.toArray(new String[parentNames.size()]));
    }

    private static List<String> getParentNames(Group group) {
        ProgramModule[] parents = group.getParents();
        if (parents == null || parents.length == 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(group.getName());
            return list;
        }
        ProgramModule parent = parents[0];
        List<String> names = Group.getParentNames(parent);
        names.add(group.getName());
        return names;
    }
}

