/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.symbol.NameTransformer;

public class IllegalCharCppTransformer
implements NameTransformer {
    private static int[] legalChars = null;
    private static final int AFTER_FIRST_CHAR = 1;
    private static final int TEMPLATE = 2;
    private static final int OPERATOR = 4;
    private static final int FIRST_CHAR = 8;

    public IllegalCharCppTransformer() {
        if (legalChars == null) {
            legalChars = new int[128];
            for (int i = 0; i < legalChars.length; ++i) {
                IllegalCharCppTransformer.legalChars[i] = 0;
            }
            IllegalCharCppTransformer.legalChars[95] = 15;
            IllegalCharCppTransformer.legalChars[48] = 7;
            IllegalCharCppTransformer.legalChars[49] = 7;
            IllegalCharCppTransformer.legalChars[50] = 7;
            IllegalCharCppTransformer.legalChars[51] = 7;
            IllegalCharCppTransformer.legalChars[52] = 7;
            IllegalCharCppTransformer.legalChars[53] = 7;
            IllegalCharCppTransformer.legalChars[54] = 7;
            IllegalCharCppTransformer.legalChars[55] = 7;
            IllegalCharCppTransformer.legalChars[56] = 7;
            IllegalCharCppTransformer.legalChars[57] = 7;
            IllegalCharCppTransformer.legalChars[42] = 6;
            IllegalCharCppTransformer.legalChars[58] = 2;
            IllegalCharCppTransformer.legalChars[40] = 6;
            IllegalCharCppTransformer.legalChars[41] = 6;
            IllegalCharCppTransformer.legalChars[91] = 6;
            IllegalCharCppTransformer.legalChars[93] = 6;
            IllegalCharCppTransformer.legalChars[44] = 2;
            IllegalCharCppTransformer.legalChars[38] = 6;
            IllegalCharCppTransformer.legalChars[43] = 4;
            IllegalCharCppTransformer.legalChars[45] = 4;
            IllegalCharCppTransformer.legalChars[124] = 4;
            IllegalCharCppTransformer.legalChars[61] = 4;
            IllegalCharCppTransformer.legalChars[33] = 4;
            IllegalCharCppTransformer.legalChars[47] = 4;
            IllegalCharCppTransformer.legalChars[37] = 4;
            IllegalCharCppTransformer.legalChars[94] = 4;
            IllegalCharCppTransformer.legalChars[126] = 14;
        }
    }

    @Override
    public String simplify(String input) {
        int templateDepth = 0;
        char[] transform = null;
        for (int i = 0; i < input.length(); ++i) {
            int val;
            char c = input.charAt(i);
            if (Character.isLetter(c)) continue;
            if (c == '<') {
                ++templateDepth;
                continue;
            }
            if (c == '>') {
                if (--templateDepth >= 0) continue;
                templateDepth = 0;
                continue;
            }
            if (c < '\u0080' && (val = legalChars[c]) != 0 && ((val & 1) != 0 && i > 0 || (val & 8) != 0 && i == 0 || (val & 2) != 0 && templateDepth > 0 || (val & 4) != 0 && i >= 8 && i <= 10 && input.startsWith("operator"))) continue;
            if (transform == null) {
                transform = new char[input.length()];
                input.getChars(0, input.length(), transform, 0);
            }
            transform[i] = 95;
        }
        if (transform == null) {
            return input;
        }
        return new String(transform);
    }
}

