/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.modifier.MDModifierType;

public class MDQuestionModifierType
extends MDModifierType {
    private String suffix;

    public MDQuestionModifierType(MDMang dmang) {
        super(dmang);
        this.cvMod.setQuestionType();
    }

    @Override
    protected void parseInternal() throws MDException {
        super.parseInternal();
        this.parseSuffix();
    }

    public String getSuffix() {
        return this.suffix;
    }

    private void parseSuffix() {
        if (this.dmang.peek() == '`') {
            int baseLoc = this.dmang.getIndex();
            StringBuilder builder = new StringBuilder();
            builder.append(this.dmang.getAndIncrement());
            for (int i = 0; i < 8; ++i) {
                if (this.dmang.done()) {
                    this.dmang.setIndex(baseLoc);
                    return;
                }
                char c = this.dmang.getAndIncrement();
                if (!MDQuestionModifierType.isHexDigit(c)) {
                    this.dmang.setIndex(baseLoc);
                    return;
                }
                builder.append(c);
            }
            this.suffix = builder.toString();
        }
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @Override
    protected MDDataType parseReferencedType() throws MDException {
        return MDDataTypeParser.parsePrimaryDataType(this.dmang, false);
    }
}

