/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.util.ArrayList;
import java.util.List;

public class C13CrossScopeImport {
    private int offsetObjectFilePath;
    private long numCrossReferences;
    private List<Long> referenceIds;

    public static int getBaseRecordSize() {
        return 8;
    }

    public C13CrossScopeImport(PdbByteReader reader) throws PdbException {
        this.offsetObjectFilePath = reader.parseInt();
        this.numCrossReferences = reader.parseUnsignedIntVal();
        this.referenceIds = new ArrayList<Long>();
        for (long i = 0L; i < this.numCrossReferences; ++i) {
            this.referenceIds.add(reader.parseUnsignedIntVal());
        }
    }

    public long getOffsetObjectFilePath() {
        return this.offsetObjectFilePath;
    }

    public long getNumCrossReferences() {
        return this.numCrossReferences;
    }

    public List<Long> getReferenceIds() {
        return this.referenceIds;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("0x%08x, %5d", this.offsetObjectFilePath, this.numCrossReferences));
        for (Long id : this.referenceIds) {
            builder.append(String.format(" 0x%08x", id));
        }
        return builder.toString();
    }
}

