/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;

public class PeCoffSectionMsSymbol
extends AbstractMsSymbol
implements NameMsSymbol {
    public static final int PDB_ID = 4406;
    private int sectionNumber;
    private int align;
    private int reserved;
    private int rva;
    private int length;
    private int characteristics;
    private String name;

    public PeCoffSectionMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.sectionNumber = pdb.parseSegment(reader);
        this.align = reader.parseUnsignedByteVal();
        this.reserved = reader.parseUnsignedByteVal();
        this.rva = reader.parseInt();
        this.length = reader.parseInt();
        this.characteristics = reader.parseInt();
        this.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4406;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public int getAlign() {
        return this.align;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getRva() {
        return this.rva;
    }

    public int getLength() {
        return this.length;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X], RVA = %08x, Length = %08X, Align = %08X, Characteristics = %08X, %s", this.getSymbolTypeName(), this.sectionNumber, this.rva, this.length, this.align, this.characteristics, this.name));
    }

    @Override
    protected String getSymbolTypeName() {
        return "SECTION";
    }
}

