/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import java.math.BigInteger;

public class BaseInterfaceMsType
extends AbstractMsType {
    public static final int PDB_ID = 5402;
    private RecordNumber baseClassRecordNumber;
    private ClassFieldMsAttributes attribute;
    private BigInteger offset;

    public BaseInterfaceMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.attribute = new ClassFieldMsAttributes(reader);
        this.baseClassRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.offset = numeric.getIntegral();
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 5402;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        this.attribute.emit(builder);
        builder.append(":");
        builder.append(this.pdb.getTypeRecord(this.baseClassRecordNumber));
        builder.append("<@");
        builder.append(this.offset);
        builder.append(">");
    }
}

