/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;

public class PointerMsType
extends AbstractPointerMsType {
    public static final int PDB_ID = 4098;
    private boolean isRestrict;
    private int size;
    private boolean isMocom;
    private boolean isLRef;
    private boolean isRRef;
    private boolean unk;

    public PointerMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.underlyingRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.parseAttributes(reader);
        this.parseExtendedPointerInfo(reader, 32, StringParseType.StringNt);
    }

    @Override
    public int getPdbId() {
        return 4098;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public boolean isMocom() {
        return this.isMocom;
    }

    public boolean isLeftReference() {
        return this.isLRef;
    }

    public boolean isRightReference() {
        return this.isRRef;
    }

    public boolean isUnknownAttributes() {
        return this.unk;
    }

    @Override
    protected void parseAttributes(PdbByteReader reader) throws PdbException {
        long attributes = reader.parseUnsignedIntVal();
        this.pointerType = AbstractPointerMsType.PointerType.fromValue((int)(attributes & 0x1FL));
        this.pointerMode = AbstractPointerMsType.MsPointerMode.fromValue((int)((attributes >>= 5) & 7L));
        this.isFlat = ((attributes >>= 3) & 1L) == 1L;
        this.isVolatile = ((attributes >>= 1) & 1L) == 1L;
        this.isConst = ((attributes >>= 1) & 1L) == 1L;
        this.isUnaligned = ((attributes >>= 1) & 1L) == 1L;
        this.isRestrict = ((attributes >>= 1) & 1L) == 1L;
        this.size = (int)((attributes >>= 1) & 0x3FL);
        this.isMocom = ((attributes >>= 6) & 1L) == 1L;
        this.isLRef = ((attributes >>= 1) & 1L) == 1L;
        this.isRRef = ((attributes >>= 1) & 1L) == 1L;
        this.unk = ((attributes >>= 1) & 1L) == 1L;
    }

    @Override
    protected int getMySize() {
        return this.size;
    }
}

