/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractBlockMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.AbstractBlockContextApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class BlockSymbolApplier
extends MsSymbolApplier
implements BlockNestingSymbolApplier,
NestableSymbolApplier {
    private AbstractBlockMsSymbol symbol;

    public BlockSymbolApplier(DefaultPdbApplicator applicator, AbstractBlockMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (applyToApplier instanceof AbstractBlockContextApplier) {
            AbstractBlockContextApplier applier = (AbstractBlockContextApplier)applyToApplier;
            Address address = this.applicator.getAddress(this.symbol);
            applier.beginBlock(address, this.symbol.getName(), this.symbol.getLength());
        }
    }

    private AbstractBlockMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractBlockMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractBlockMsSymbol blockSymbol = (AbstractBlockMsSymbol)abstractSymbol;
        return blockSymbol;
    }
}

