/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.SeparatedCodeFromCompilerSupportMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.AbstractBlockContextApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class SeparatedCodeSymbolApplier
extends AbstractBlockContextApplier
implements BlockNestingSymbolApplier,
NestableSymbolApplier {
    private SeparatedCodeFromCompilerSupportMsSymbol symbol;

    public SeparatedCodeSymbolApplier(DefaultPdbApplicator applicator, SeparatedCodeFromCompilerSupportMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        Address address = this.applicator.getAddress(this.symbol);
        if (!this.processEndSymbol(this.symbol.getEndPointer(), iter)) {
            this.applicator.appendLogMsg("PDB: Failed to process function at address " + String.valueOf(address));
            return;
        }
        if (this.applicator.isInvalidAddress(address, this.craftBlockComment(address))) {
            return;
        }
        this.applyPlateComment(address);
    }

    @Override
    public void deferredApply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        Address address = this.applicator.getAddress(this.symbol);
        long start = this.getStartOffset();
        long end = this.getEndOffset();
        Address blockAddress = address.add(start);
        long length = end - start;
        this.deferredProcessing(iter, this.craftBlockComment(blockAddress), address, blockAddress, length);
    }

    private String craftBlockComment(Address address) {
        return String.format("CompilerSeparatedCode%s", address);
    }

    private void applyPlateComment(Address address) {
        Address parentAddress = this.applicator.getAddress(this.symbol.getSegmentParent(), this.symbol.getOffsetParent());
        String comment = String.format("PDB: Separated code (from the compiler): %s - %s for parent address: %s", address.toString(), address.add(this.symbol.getBlockLength() - 1L).toString(), parentAddress.toString());
        this.applicator.addToPlateUnique(address, comment);
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (applyToApplier instanceof AbstractBlockContextApplier) {
            AbstractBlockContextApplier applier = (AbstractBlockContextApplier)applyToApplier;
            Address address = this.applicator.getAddress(this.symbol);
            applier.beginBlock(address, null, 0L);
        }
    }

    @Override
    long getStartOffset() {
        return this.symbol.getParentPointer();
    }

    @Override
    long getEndOffset() {
        return this.symbol.getEndPointer();
    }

    boolean returnsToParent() {
        return this.symbol.returnsToParent();
    }

    private SeparatedCodeFromCompilerSupportMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof SeparatedCodeFromCompilerSupportMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        SeparatedCodeFromCompilerSupportMsSymbol sepCodeSymbol = (SeparatedCodeFromCompilerSupportMsSymbol)abstractSymbol;
        return sepCodeSymbol;
    }
}

