/*
 * Decompiled with CFR 0.152.
 */
package ghidra.launch;

import ghidra.launch.JavaFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LaunchProperties {
    public static String JAVA_HOME_OVERRIDE = "JAVA_HOME_OVERRIDE";
    public static String VMARGS = "VMARGS";
    public static String VMARGS_PLATFORM = "VMARGS_" + (Object)((Object)JavaFinder.getCurrentPlatform());
    private Map<String, List<String>> propertyMap;
    private File launchPropertiesFile;

    public LaunchProperties(File launchPropertiesFile) throws FileNotFoundException, IOException, ParseException {
        this.launchPropertiesFile = launchPropertiesFile;
        this.propertyMap = LaunchProperties.parseLaunchProperties(launchPropertiesFile);
    }

    public File getLaunchPropertiesFile() {
        return this.launchPropertiesFile;
    }

    public File getJavaHomeOverride() {
        List<String> javaHome = this.propertyMap.get(JAVA_HOME_OVERRIDE);
        if (javaHome != null && !javaHome.isEmpty()) {
            return new File(javaHome.get(0));
        }
        return null;
    }

    public String getVmArgs() {
        List<String> vmargPlatformList;
        StringBuilder sb = new StringBuilder();
        List<String> vmargList = this.propertyMap.get(VMARGS);
        if (vmargList != null) {
            for (String arg : vmargList) {
                sb.append(arg);
                sb.append(" ");
            }
        }
        if ((vmargPlatformList = this.propertyMap.get(VMARGS_PLATFORM)) != null) {
            for (String arg : vmargPlatformList) {
                sb.append(arg);
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public List<String> getVmArgList() {
        List<String> vmargPlatformList;
        ArrayList<String> ret = new ArrayList<String>();
        List<String> vmargList = this.propertyMap.get(VMARGS);
        if (vmargList != null) {
            ret.addAll(vmargList);
        }
        if ((vmargPlatformList = this.propertyMap.get(VMARGS_PLATFORM)) != null) {
            ret.addAll(vmargPlatformList);
        }
        return ret;
    }

    private static Map<String, List<String>> parseLaunchProperties(File launchPropertiesFile) throws FileNotFoundException, IOException, ParseException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (launchPropertiesFile != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(launchPropertiesFile));){
                String line;
                int i = 0;
                while ((line = reader.readLine()) != null) {
                    ++i;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
                    int equalsIndex = line.indexOf(61);
                    if (equalsIndex <= 0) {
                        throw new ParseException("Error parsing line " + i + " of " + launchPropertiesFile, i);
                    }
                    String key = line.substring(0, equalsIndex).trim();
                    String value = line.substring(equalsIndex + 1, line.length()).trim();
                    List<String> valueList = map.get(key);
                    if (valueList == null) {
                        valueList = new ArrayList<String>();
                        map.put(key, valueList);
                    }
                    if (value.isEmpty()) continue;
                    valueList.add(value);
                }
            }
        }
        return map;
    }
}

