/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.signature;

import ghidra.app.decompiler.signature.BlockSignature;
import ghidra.app.decompiler.signature.CopySignature;
import ghidra.app.decompiler.signature.VarnodeSignature;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import java.util.ArrayList;

public abstract class DebugSignature {
    public int hash;

    public abstract void decode(Decoder var1) throws DecoderException;

    public abstract void printRaw(Language var1, StringBuffer var2);

    public static ArrayList<DebugSignature> decodeSignatures(Decoder decoder, Function func) throws DecoderException {
        ArrayList<DebugSignature> res = new ArrayList<DebugSignature>();
        int el = decoder.openElement();
        int subel = decoder.peekElement();
        while (subel != 0) {
            DebugSignature sig;
            if (subel == ElementId.ELEM_VARSIG.id()) {
                sig = new VarnodeSignature();
            } else if (subel == ElementId.ELEM_BLOCKSIG.id()) {
                sig = new BlockSignature();
            } else if (subel == ElementId.ELEM_COPYSIG.id()) {
                sig = new CopySignature();
            } else {
                throw new DecoderException("Unknown debug signature element");
            }
            ((DebugSignature)sig).decode(decoder);
            res.add(sig);
            subel = decoder.peekElement();
        }
        decoder.closeElement(el);
        return res;
    }
}

