/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.HelpLocation;

public class ConvertDecAction
extends ConvertConstantAction {
    public ConvertDecAction(DecompilePlugin plugin) {
        super(plugin, "Convert To Decimal", 2);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionConvert"));
        this.setPopupMenuData(new MenuData(new String[]{"Decimal"}, "Decompile"));
    }

    @Override
    public String getMenuPrefix() {
        return "Decimal: ";
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned, Program program) {
        return this.getEquateName(value, size, isSigned, program);
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        Scalar scalar = new Scalar(size * 8, value);
        if (isSigned) {
            return Long.toString(scalar.getSignedValue());
        }
        return Long.toString(scalar.getUnsignedValue());
    }
}

