/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.SliceHighlightColorProvider;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.HelpLocation;
import java.util.Set;

public class HighlightDefinedUseAction
extends AbstractDecompilerAction {
    public HighlightDefinedUseAction() {
        super("Highlight Defined Use");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionHighlight"));
        this.setPopupMenuData(new MenuData(new String[]{"Highlight", "Def-use"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        return varnode != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        if (varnode == null) {
            return;
        }
        DecompilerPanel decompilerPanel = context.getDecompilerPanel();
        decompilerPanel.clearPrimaryHighlights();
        Set<Varnode> varnodes = Set.of(varnode);
        PcodeOp op = varnode.getDef();
        SliceHighlightColorProvider colorProvider = new SliceHighlightColorProvider(decompilerPanel, varnodes, varnode, op);
        decompilerPanel.addHighlights(varnodes, colorProvider);
    }
}

