/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.sem;

import ghidra.app.plugin.assembler.sleigh.expr.OperandValueSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyNopState;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.asm.wild.sem.PatternUtils;
import ghidra.asm.wild.sem.WildAssemblyResolvedPatterns;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class WildAssemblyNopState
extends AssemblyNopState {
    protected final OperandSymbol opSym;
    protected final String wildcard;

    public WildAssemblyNopState(AbstractAssemblyTreeResolver<?> resolver, List<AssemblyConstructorSemantic> path, int shift, OperandSymbol opSym, String wildcard) {
        super(resolver, path, shift, opSym);
        this.opSym = opSym;
        this.wildcard = Objects.requireNonNull(wildcard);
    }

    public int computeHash() {
        int result = super.computeHash();
        result *= 31;
        return result += this.wildcard.hashCode();
    }

    protected boolean wildPartsEqual(WildAssemblyNopState that) {
        if (!this.partsEqual(that)) {
            return false;
        }
        return this.wildcard.equals(that.wildcard);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WildAssemblyNopState that = (WildAssemblyNopState)((Object)obj);
        return this.wildPartsEqual(that);
    }

    public String toString() {
        return "WILD:" + super.toString();
    }

    protected WildAssemblyResolvedPatterns castWildPatterns(AssemblyResolvedPatterns rp) {
        return (WildAssemblyResolvedPatterns)rp;
    }

    protected Stream<AssemblyResolvedPatterns> resolve(AssemblyResolvedPatterns fromRight, Collection<AssemblyResolvedError> errors) {
        PatternExpression symExp = OperandValueSolver.getDefiningExpression((OperandSymbol)this.opSym);
        AssemblyPatternBlock location = PatternUtils.collectLocation(symExp).shift(this.shift);
        return super.resolve(fromRight, errors).map(PatternUtils::castWild).map(r -> r.withWildInfo(this.wildcard, this.path, location, symExp, null));
    }
}

