/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.nio.file.Path;

public class RunPCodeExportScriptTask
extends Task {
    private PluginTool tool;
    private GhidraScript script;
    private GhidraState currentState;
    private ConsoleService console;
    private String scriptName;

    public RunPCodeExportScriptTask(PluginTool tool, GhidraScript script, GhidraState currentState, ConsoleService console) {
        super(script.getSourceFile().getName(), true, false, false);
        this.tool = tool;
        this.script = script;
        this.scriptName = script.getSourceFile().getName();
        this.console = console;
        this.currentState = currentState;
    }

    public void run(TaskMonitor monitor) {
        block5: {
            try {
                Thread.currentThread().setName(this.scriptName);
                ToolOptions options = this.tool.getOptions("Decompiler");
                String facts_directory = options.getString("Taint.Directories.Facts", "/tmp/export").trim();
                Path facts_path = Path.of(facts_directory, new String[0]);
                if (!facts_path.toFile().exists() || !facts_path.toFile().isDirectory()) {
                    Msg.info((Object)((Object)this), (Object)("Facts Path: " + facts_path.toString() + " does not exists."));
                    facts_directory = this.getDirectoryPath(facts_directory, "Select full path to the directory containing the facts files");
                    if (facts_directory == null) {
                        Msg.info((Object)((Object)this), (Object)"User cancelled operation; existing script.");
                        return;
                    }
                    Msg.info((Object)((Object)this), (Object)("Using .facts files in: " + facts_directory));
                    options.setString("Taint.Directories.Facts", facts_directory);
                }
                this.script.setScriptArgs(new String[]{facts_directory});
                this.console.addMessage(this.scriptName, "Running...");
                this.script.execute(this.currentState, monitor, this.console.getStdOut());
                this.console.addMessage(this.scriptName, "Finished!");
            }
            catch (CancelledException e) {
                this.console.addErrorMessage(this.scriptName, "User cancelled script.");
            }
            catch (Exception e) {
                if (monitor.isCancelled()) break block5;
                Msg.showError((Object)((Object)this), null, (String)this.getTaskTitle(), (Object)("Error running script: " + this.scriptName + "\n" + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                this.console.addErrorMessage("", "Error running script: " + this.scriptName);
                this.console.addException(this.scriptName, e);
            }
        }
    }

    private String getDirectoryPath(String path, String title) {
        GhidraFileChooser chooser = new GhidraFileChooser(null);
        chooser.setCurrentDirectory(new File(path));
        chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        chooser.setTitle(title);
        File selectedDir = chooser.getSelectedFile();
        if (selectedDir != null && !chooser.wasCancelled()) {
            return selectedDir.getAbsolutePath();
        }
        return null;
    }

    public Program getProgram() {
        return this.script.getCurrentProgram();
    }
}

